/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.14
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *------------------------------- ժҪ ----------------------------------
;  *                                EEPROM 
;  *                        64ַд,ٶԱ
;  *                        ϵʱP03ΪߣEEPROMʼдʱP00Ϊ
;  *                        ддԱȣͬʱP00Ϊߣ֮P00Ϊ
;  *                        ͨѶ P10(PDT0)P11(PCK0)
;******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : DELAY
;  *    @Description         : ȷʱ
;  *    @IN_Parameter        : num
;  *    @Return parameter    : 
;  ***********************************************/
void DELAY(uint16_t num)
{
    uint16_t i;
    for (i = 0; i < num; i++)
    {
        Nop();
    }
}

/************************************************
;  *    @Function Name       : INIT_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @Function Name       : INIT_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_GPIO(void)
{
//  IOλ
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;
//  IO          1:  0:
    OEP0 = 0xff;
    OEP1 = 0xff;
    OEP2 = 0xff;
//  IO      1:  0:ر
    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;
//  IO      1:  0:ر
    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
//  IOģѡ      1:ģ  0:
    P0ADCR = 0x00;
    P1ADCR = 0x00;
    P2ADCR = 0x00;
}

/************************************************
;  *    @Function Name       : EEPROM_WRITE_BYTE
;  *    @Description         : дĵַ д
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void EEPROM_WRITE_BYTE(uint8_t addr, uint8_t data)
{
    EEAR = addr;
    EEDR = data;
    GIE = DISABLE;
    EEPR = 0x5A;
    EEPR = 0xA5;    // 
    EECR = 0x01;    // EEPROMд
    Nop();
    Nop();
    while(EEWRITE)  // ȴд
    {
        ClrWdt();   // 忴Ź
    }
    GIE = ENABLE;
}

/************************************************
;  *    @Function Name       : EEPROM_WRITE_DATA
;  *    @Description         : д
;  *    @IN_Parameter        : ʼַ顢
;  *    @Return parameter    : 
;  ***********************************************/ 
void EEPROM_WRITE_DATA(u8 addr, u8 *data, u8 len)
{
    while (len)
    {
        EEPROM_WRITE_BYTE(addr++, *data++);
        len--;
    }
}

/************************************************
;  *    @Function Name       : EEPROM_READ_BYTE
;  *    @Description         : һֽ
;  *    @IN_Parameter        : ַ
;  *    @Return parameter    : 
;  ***********************************************/ 
uint8_t EEPROM_READ_BYTE(u8 addr)
{
    EEAR = addr;
    EECR = 0x02;    // EEPROM
    while(EEREAD)   // ȴȡ
    {
        ClrWdt();   // 忴Ź
    }
    return EEDR;
}

 /************************************************
;  *    @Function Name       : EEPROM_READ_DATA
;  *    @Description         : ȡ
;  *    @IN_Parameter        : ʼַ顢
;  *    @Return parameter    : 
;  ***********************************************/ 
void EEPROM_READ_DATA(u8 addr, u8 *data, u8 len)
{
    while (len)
    {
        data[64-len] = EEPROM_READ_BYTE(addr++);
        len--;
    }
}

 /************************************************
;  *    @Function Name       : INIT_SYS
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_SYS(void)
{
    GIE = 0;
    INIT_RAM();
    INIT_GPIO();
    GIE = 1;
}

 /************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void main(void)
{
    INIT_SYS();
    P00D = 1;
    DELAY(60000);
   	DELAY(60000);
   	DELAY(60000);
    P00D = 0;
    EEPROM_WRITE_DATA(0,EEPROM_WDATA,64);  // д
   	EEPROM_READ_DATA(0,EEPROM_RBUFF,64);   // ȡ
   	for(i = 0; i < 64; i++)
    {
        if( EEPROM_RBUFF[i] == EEPROM_WDATA[i]) {
            P00D = 1;
        } else {
            P00D = 0;
            break;
        }
   	}
    while (1)
    {
        ClrWdt();
    }
}

 /************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϷ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
