/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.15
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                궨
;******************************************************************************/
#ifndef USER
#define USER

#include "MC32F7062B.h"

#define u8 unsigned char
#define u16 unsigned int
#define u32 unsigned long int
#define uint8_t  unsigned char
#define uint16_t unsigned int
#define uint32_t unsigned long int

#define DEF_SET_BIT0                0x01
#define DEF_SET_BIT1                0x02
#define DEF_SET_BIT2                0x04
#define DEF_SET_BIT3                0x08
#define DEF_SET_BIT4                0x10
#define DEF_SET_BIT5                0x20
#define DEF_SET_BIT6                0x40
#define DEF_SET_BIT7                0x80

#define DEF_CLR_BIT0                0xFE
#define DEF_CLR_BIT1                0xFD
#define DEF_CLR_BIT2                0xFB
#define DEF_CLR_BIT3                0xF7
#define DEF_CLR_BIT4                0xEF
#define DEF_CLR_BIT5                0xDF
#define DEF_CLR_BIT6                0xBF
#define DEF_CLR_BIT7                0x7F

#define ENABLE                      1
#define DISABLE                     0

#define FAIL                        1
#define PASS                        0

//=========Field Protection Variables==========
u8 abuf;
u8 statusbuf;

//===============Global Variable===============
u8 i;

const uint8_t EEPROM_WDATA[64] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
    40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
    50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
    60, 61, 62, 63
};  // EEPROM д

uint8_t EEPROM_RBUFF[64];  // EEPROMݻ

//===============Global Function===============
void DELAY(uint16_t num);
void INIT_RAM(void);
void INIT_GPIO(void);
void EEPROM_WRITE_BYTE(uint8_t addr, uint8_t data);
void EEPROM_WRITE_DATA(u8 addr, u8 *data, u8 len);
uint8_t EEPROM_READ_BYTE(u8 addr);
void EEPROM_READ_DATA(u8 addr, u8 *data, u8 len);
void INIT_SYS(void);

//================Define  Flag=================
typedef union {
       unsigned char byte;
       struct
       {
              u8 BIT0 : 1;
              u8 BIT1 : 1;
              u8 BIT2 : 1;
              u8 BIT3 : 1;
              u8 BIT4 : 1;
              u8 BIT5 : 1;
              u8 BIT6 : 1;
              u8 BIT7 : 1;
       } BITS;
}BIT_FLAG;
volatile BIT_FLAG FLAG1;

//#define   FLAG_TIMER0_4MS   FLAG1.BITS.BIT0      // 4MS־λ

#endif

/**************************** end of file *******************************/