/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.14
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                HOLD2
;  *                        ϵP00ߣ3SP00Ϊͣϵͳ˯ģʽ
;  *                        ʱT1 ʱ1뻽 (T1ʱԴ:ڲƵ)
;  *                        ѺP00ߣ3SP00Ϊͣϵͳ½˯ģʽ
;  *                        עT1ʱжϽѣжϺ
;  *                        ͨѶ P10(PDT0)P11(PCK0)
;******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : INIT_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @Function Name       : INIT_GPIO
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_GPIO(void)
{
//  IOλ
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;
//  IO          1:  0:
    OEP0 = 0xff;
    OEP1 = 0xff;
    OEP2 = 0xff;
//  IO      1:  0:ر
    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;
//  IO      1:  0:ر
    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
//  IOģѡ      1:ģ  0:
    P0ADCR = 0x00;
    P1ADCR = 0x00;
    P2ADCR = 0x00;
}

/************************************************
;  *    @Function Name       : INIT_TIMER0
;  *    @Description         : TIMER0ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_TIMER0(void)
{
    T0CR = DEF_SET_BIT2 | DEF_SET_BIT1 | DEF_SET_BIT0;  // FCPU 8M,128Ƶ,4mS
    T0CNT = 250 -1;
    T0LOAD = 250 -1;
    T0EN = 1;
    T0IE = 1;
}

/************************************************
;  *    @Function Name       : INIT_TIMER1
;  *    @Description         : TIMER1ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_TIMER1(void)
{
    T1CR0 = DEF_SET_BIT4 | DEF_SET_BIT2 | DEF_SET_BIT1 | DEF_SET_BIT0;  // FLOSC 8M,128Ƶ,1S
    T1CNTH = 0;
    T1CNTL = 250 -1;
    T1LOADH = 0;
    T1LOADL = 250 -1;
}

/************************************************
;  *    @Function Name       : INIT_SYS
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_SYS(void)
{
    GIE = 0;
    INIT_RAM();
    INIT_GPIO();
    INIT_TIMER0();
    INIT_TIMER1();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void main(void)
{
    INIT_SYS();
    LFEN = 1;  // Ƶʼտ
    while (1)
    {
        ClrWdt();
        P00D  = 1;
        if(FLAG_TIMER0_3S) {
            FLAG_TIMER0_3S = 0;
            GIE = 0;     // رж
            T1IF = 0;
            T1IE = 1;
            T1EN = 1;    // T1 ˯߿ʼʱ1S
            P00D = 0;    // ر
            Stop();
            Nop();
            Nop();
            T1IF = 0;
            T1IE = 0;
            T1EN = 0;   // رT1ʱ
            GIE = 1;
        }
    }
}

/************************************************
;  *    @Function Name       : interrup
;  *    @Description         : жϷ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((T0IF) && (T0IE))  // 4mS
    {
        if(++g_timecnt >= 750) {
            g_timecnt = 0;
            FLAG_TIMER0_3S = 1;
        }
        T0IF = 0;
    }

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
