/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.13
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                PWM
;  *                        P06D(PWM2)   F=10K,D=50%
;  *                        P01D(PWM3A)  F=10K,D=80%
;  *                        P02D(PWM3B)  F=10K,D=50%
;  *                        P03D(PWM3C)  F=10K,D=30%
;  *                        ͨѶ P10(PDT0)P11(PCK0)
;******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : INIT_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @Function Name       : INIT_GPIO
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_GPIO(void)
{
//  IOλ
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;
//  IO          1:  0:
    OEP0 = 0xff;
    OEP1 = 0xff;
    OEP2 = 0xff;
//  IO      1:  0:ر
    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;
//  IO      1:  0:ر
    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
//  IOģѡ      1:ģ  0:
    P0ADCR = 0x00;
    P1ADCR = 0x00;
    P2ADCR = 0x00;
}

/************************************************
;  *    @Function Name       : INIT_TIMER2
;  *    @Description         : TIMER2ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  * עҪ׸ PWMںռձ׼ȷдؼĴͱȽϼĴʹ PWMʱ
;  ***********************************************/ 
void INIT_TIMER2(void)
{
    T2CR = DEF_SET_BIT1 | DEF_SET_BIT0;  // FCPU 8M,8Ƶ,100uS
    T2CNT = 100 - 1;
    T2LOAD = 100 - 1;
    T2DATA = 50;
    T2CR |= DEF_SET_BIT6;                // ʹPWM2
    PWM2CR0 |= DEF_SET_BIT0;             // PWM2 P06 
    T2EN = 1;
}

/************************************************
;  *    @Function Name       : INIT_TIMER3
;  *    @Description         : TIMER3ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  * עҪ׸ PWMںռձ׼ȷдؼĴͱȽϼĴʹ PWMʱ
;  ***********************************************/ 
void INIT_TIMER3(void)
{
    T3CR = DEF_SET_BIT1 | DEF_SET_BIT0;     // FCPU 8M,8Ƶ,100uS
    T3CNT = 100 - 1;
    T3LOAD = 100 - 1;
    T3DATA = 80;
    T3DATB = 50;
    T3DATC = 30;
    T3CR |= DEF_SET_BIT6;                                  // ʹPWM3A
    PWM3CR0 = DEF_SET_BIT7 | DEF_SET_BIT6;                 // ʹPWM3BʹPWM3C
    PWM3CR1 = DEF_SET_BIT3 | DEF_SET_BIT2 | DEF_SET_BIT1;  // PWM3ֱ P01DP02DP03D 
    T3EN = 1;
}
/************************************************
;  *    @Function Name       : INIT_SYS
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_SYS(void)
{
    GIE = 0;
    INIT_RAM();
    INIT_GPIO();
    INIT_TIMER2();
    INIT_TIMER3();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void main(void)
{
    INIT_SYS();
    while (1)
    {
        ClrWdt();
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
