/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.14
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                궨
;******************************************************************************/
#ifndef USER
#define USER

#include "MC32F7062B.h"

#define u8 unsigned char
#define u16 unsigned int
#define u32 unsigned long int
#define uint8_t  unsigned char
#define uint16_t unsigned int
#define uint32_t unsigned long int

#define DEF_SET_BIT0                0x01
#define DEF_SET_BIT1                0x02
#define DEF_SET_BIT2                0x04
#define DEF_SET_BIT3                0x08
#define DEF_SET_BIT4                0x10
#define DEF_SET_BIT5                0x20
#define DEF_SET_BIT6                0x40
#define DEF_SET_BIT7                0x80

#define DEF_CLR_BIT0                0xFE
#define DEF_CLR_BIT1                0xFD
#define DEF_CLR_BIT2                0xFB
#define DEF_CLR_BIT3                0xF7
#define DEF_CLR_BIT4                0xEF
#define DEF_CLR_BIT5                0xDF
#define DEF_CLR_BIT6                0xBF
#define DEF_CLR_BIT7                0x7F

#define ENABLE                      1
#define DISABLE                     0

#define FAIL                        1
#define PASS                        0

//=========Field Protection Variables==========
u8 abuf;
u8 statusbuf;

//===============Global Variable===============

//===============Global Function===============
void INIT_RAM(void);
void INIT_GPIO(void);
void INIT_TIMER2(void);
void INIT_TIMER3(void);
void INIT_SYS(void);

//================Define  Flag=================
typedef union {
        unsigned char byte;
        struct
        {
            u8 BIT0 : 1;
            u8 BIT1 : 1;
            u8 BIT2 : 1;
            u8 BIT3 : 1;
            u8 BIT4 : 1;
            u8 BIT5 : 1;
            u8 BIT6 : 1;
            u8 BIT7 : 1;
        } BITS;
}BIT_FLAG;
volatile BIT_FLAG FLAG1;

// #define   FLAG_TIMER0_4MS   FLAG1.BITS.BIT0      // 4MS־λ

#endif

/**************************** end of file *******************************/