/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2024.01.11
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2024 ΢
;  *----------------------ժҪ---------------------------------
;  *       ¶ƫ
;  *       1)AD룺¶ȴѹVIS룺GND
;  *       LDO 2.8V   οѹ:1.024V  ٲHIRC/24   128
;  *                ADCŴ1   FPGAŴ1  ADɼ16λ
;  *       2)       UART_TX: P02,ʣ115200
;  *       3)¶ȴ:ģʽ1,,ͨ궨TSMOD_0޸(Ŀǰʹģʽ1)
;  *       3)̹:ʱ2sɼ,ADֵ(λ)¶(λ)ͨUARTӡ
;  *                  ˲20Σͨ궨USER_FILTERING޸
;  *                  UARTӡʽ0x5A 8λ(AD) 8λ(AD) Sens_Temp1(8λ) Sens_Temp1(8λ)
;  *                  ADC_Temp1(8λ) ADC_Temp1(8λ) V_DATA8λV_DATA8λ¶ȷλ(1Ϊ,0Ϊ) 8λ(¶) 0xA5
;  *       עԿʹPDT1(P00)PCK1(P01)
;  *       ע¶ȴ뿪PGAοѹѡ1.024V
******************************************************************************/

#include "user.h"

u16 i;
u32 ADC_TEMP1_addr;
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BACK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BACK0();
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : ADC_Init
;  *    @Description         : ADCʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void ADC_Init(void)
{
    /*ADC*/
    ADCR0 |= DEF_SET_BIT5;                                      //ʹVIR
    ADCR0 |= DEF_SET_BIT3 | DEF_SET_BIT2 | DEF_SET_BIT0;        //ʹLDO2.8V
    ADCR1 = 0x8A;             //ѡοѹΪ1.024VPGAŴ1ADCŴ1
    ADCR2 = 0x22;
    ADCR3 = 0xC7;             //PGAն CHOPƵ FDADC/1024
    ADCR4 = 0xEF;
#if TSMOD_0    //TSMOD_0=1
    TSMOD = 1;
#else
    TSMOD = 0;
#endif
    /*ʹADC*/
    ADEN = 1;                                                   //ʹ
}
/************************************************
;  *    @Function Name       : ADC_Get_Value_Average
;  *    @Description         : ת
;  *    @IN_Parameter        : ͨ
;  *    @Return parameter    : ADCֵ
;  ***********************************************/   
u32 ADC_Get_Value_Average(u8 P_CHX,u8 N_CHX)
{
    ADC_filtering = 0;
    get_adc_value_temp = 0;
    adc_value_buf_M = 0;
    adc_value_buf_N = 0;

    ADCR4 &= 0x00;
    ADCR4 |= (P_CHX << 4) | N_CHX;                                             //ͨ
    for(ADC_filtering = 0;ADC_filtering < USER_FILTERING;ADC_filtering ++)
    {
   	   	ClrWdt();                              	   	   	   	   	   	   	   	   //WDT;WDTɾ
        ADCONEN = 1;                                                           //ת
        ADIF = 0;
        while(ADIF == 0);                                                      //ȴת
        ADIF = 0;

        get_adc_value_temp = ADRH;
        get_adc_value_temp = (get_adc_value_temp << 8) | ADRM;
            
        if(ADC_filtering < 2)
        {
            continue;                                                          //ǰν
        }
        if(get_adc_value_temp & 0x8000)//
        {
            get_adc_value_temp = 0xFFFF - get_adc_value_temp + 1 ;
            adc_value_buf_M += get_adc_value_temp;
        }
        else
        {
            adc_value_buf_N += get_adc_value_temp;
        }
    }
    if(adc_value_buf_M > adc_value_buf_N)//
    {
        get_adc_value_temp = (adc_value_buf_M - adc_value_buf_N)/(USER_FILTERING - 2);          //ƽ
        get_adc_value_temp = 0xFFFF - get_adc_value_temp + 1 ;
    }
    else
        get_adc_value_temp = (adc_value_buf_N - adc_value_buf_M)/(USER_FILTERING - 2);          //ƽ
    return get_adc_value_temp;
}
/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : ʱ0ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void TIMER0_INT_Init(void)
{
    T0CR |= DEF_SET_BIT1;           //ʱģʽ,CPU,4Ƶ
    T0CNTH = 0x27;
    T0CNTL = 0x10 - 1;
    T0LOADH = 0x27;                 //1ms
    T0LOADL = 0x10 - 1;
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @Function Name       : UART_Init
;  *    @Description         : UARTʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void UART_Init(void)
{
    OEP0 |= DEF_SET_BIT2;           //TX
    OEP0 &= DEF_CLR_BIT3;           //RX

    PUP0 |= DEF_SET_BIT3;           //RX

    IOP0 |= DEF_SET_BIT2;           //TX
    IOP0 |= DEF_SET_BIT3;           //RX

    URTCR0 = 0x40;                  //ʱӷƵ1:1
    URTCR1 = 0;
    URTCR2 = 0;
    URTBR = 68;                     //115200

    URTEN = 1;                      //ʹUART
}
/************************************************
;  *    @Function Name       : UART_Send_Byte
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/ 
void UART_Send_Byte(u8 dat)
{
    UREN = 0;
    RXIE = 0;

    URTDR = dat;
    while(0 == TXIF)                //ȴǰݷ
    {
        ClrWdt();                   //忴Ź
    }
    TXIF = 0;

    UREN = 1;
    RXIE = 1;
}
/************************************************
;  *    @Function Name       : Read_TEMP
;  *    @Description         : ȡcodeУ׼ֵ
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/ 
void Read_TEMP(void)
{
__asm
    movai 0x80
    movra FSR1
    movai 0x3b
    movra FSR0
    movar INDF3
    movra _tmp275_adl
    movar HIBYTE
    movra _tmp275_adh

    movai 0x80
    movra FSR1
    movai 0x3C
    movra FSR0
    movar INDF3
    movra _tmod1_adl
    movar HIBYTE
    movra _tmod1_adh

   	movai 0x80
    movra FSR1
    movai 0x3E
    movra FSR0
    movar INDF3
    movra _tmod2_adl
    movar HIBYTE
    movra _tmod2_adh

__endasm;

#if(!TSMOD_0)
    V_DATA = (tmod1_adh << 8) | tmod1_adl;                 //궨ѹֵ
#else
    V_DATA = (tmod2_adh << 8) | tmod2_adl;
#endif
    Sens_Temp1 = (tmp275_adh << 8) | tmp275_adl;
}
/************************************************
;  *    @Function Name       : Offset_Compute
;  *    @Description         : offset
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/ 
void Offset_Compute(void)
{
    VADC_data= SinoDIV(VREF2,FULL_SCALE);
    VADC_data= SinoMUL(VADC_data,get_adc_value);
    VADC_data= SinoDIV(VADC_data,10000);              //ʵѹֵ
}
/************************************************
;  *    @Function Name       : Temperature_Compute
;  *    @Description         : ʵ¶
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/ 

void Temperature_Compute(void)
{
    if (VADC_data >= V_DATA)
    {
        Temperature = VADC_data-V_DATA;
        //Temperature = SinoDIV(Temperature,2);   //ʵ¶>궨¶
   	   	Temperature >>=1;
        #if(!TSMOD_0)  //ģʽ0
        {
            if(Temperature>TSens_Temp1)
            {
                Temperature = Temperature - TSens_Temp1 ; //ʵ¶<0
                F_Final_0 = 1;
            }     
            else 
            {
                Temperature = TSens_Temp1 -Temperature ;   //0~궨ֵ
            }   
        }
        #else         //ģʽ1
        {
            Temperature = Temperature + TSens_Temp1;
        }
        #endif
    }
    else
    {
        Temperature = V_DATA-VADC_data;
        //Temperature = SinoDIV(Temperature,2);
   	   	Temperature >>=1;
        #if(!TSMOD_0)  //ģʽ0
        {
            Temperature = Temperature + TSens_Temp1;
        }
        #else
        {
            if(Temperature>TSens_Temp1)
            {
                Temperature = Temperature - TSens_Temp1 ; //ʵ¶<0
                F_Final_0 = 1;
            }     
            else 
            {
                Temperature = TSens_Temp1 -Temperature ;   //0~궨ֵ
            }   
        }
        #endif
    }
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    UART_Init();
    ADC_Init();
    TIMER0_INT_Init();
    Read_TEMP();
    GIE  = 1;
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
   	TSens_Temp1 = SinoMUL(unit,Sens_Temp1);
    TSens_Temp1 = SinoDIV(TSens_Temp1,100000);
    while(1)
    {   
        if(F_TIMER_2S == SET)
        {  	
            F_TIMER_2S = 0;
            get_adc_value = ADC_Get_Value_Average(14,15);  //VISGND
            get_adc_adrh = get_adc_value >> 8;
            get_adc_adrm = get_adc_value;
            Offset_Compute();
            Temperature_Compute();
            if(F_Final_0==1)    //Temperature<0 λΪ1
            {
                F_Final_0 = 0;
                Temper_h = 0x01;
            }
            else
            {
                Temper_h = 0x00;
            }
            UART_Send_Byte(0x5A);
            UART_Send_Byte(get_adc_adrh);
            UART_Send_Byte(get_adc_adrm);
            UART_Send_Byte(tmp275_adh);
            UART_Send_Byte(tmp275_adl);
            UART_Send_Byte(tmod1_adh);
            UART_Send_Byte(tmod1_adl);
   	   	   	UART_Send_Byte(tmod2_adh);
            UART_Send_Byte(tmod2_adl);
            UART_Send_Byte(Temper_h);
            UART_Send_Byte(Temperature);
            UART_Send_Byte(0xA5);
        }
    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  
    INT_BACK = RBS;          //жϻݴ洢ҳ
    BACK0();                 //ݳѡ01

    if(T0IE & T0IF)
    {
        T0IF = 0;
        timer_count ++;
        if(timer_count == 200)
        {
            timer_count = 0;
            F_TIMER_2S = SET;
            // P15D = !P15D;
        }
    }

    RBS = INT_BACK;          //˳жϻԭݴ洢ҳ
__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}
/************************************************
;  *    @Function Name       : SinoDIV
;  *    @Description         : ų
;  *    @IN_Parameter        : divisor()dividend()
;  *    @Return parameter    : quotient()/
;  ***********************************************/   
uint32_t SinoDIV(uint32_t dividend,uint32_t divisor)
{
    uint32_t    quotient;
    uint32_t    DIV_HighBit=0x80000000;
    uint8_t     counter;

    remainder = 0;
    quotient = 0;
    if(divisor != 0) {
        counter = 1;
        while((divisor & DIV_HighBit) == 0) {
            divisor <<= 1;
            counter++;
        }
        do {
            quotient <<= 1;
            if(divisor <= dividend) {
                dividend -= divisor;
                quotient |= 1;
            }
            divisor >>= 1;
        } while(--counter != 0);
        remainder = dividend;
    }
    if(!F_remainder)
    {return quotient;}
    else
    {
        F_remainder = 0;
        return remainder;
    }
}
/************************************************
;  *    @Function Name       : SinoMUL
;  *    @Description         : ų˷
;  *    @IN_Parameter        : multiplier()multiplicand()
;  *    @Return parameter    : product()
;  ***********************************************/   
uint32_t SinoMUL(uint32_t multiplier, uint32_t multiplicand)
{
    uint32_t    product = 0;
    do {
        if(multiplier & 1)
            product += multiplicand;
        multiplicand <<= 1;
        multiplier >>= 1;
    } while(multiplier != 0);
    return product;
}
/**************************** end of file *********************************************/