/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------ժҪ---------------------------------
;  *       ADC
;  *       1):  ADC:AN2(P12)    ADC:AN3(P13)
;  *                UART_TX: P02
;  *       2):  LDO 2.8V   οѹ:1/2LDO  ٲHIRC/24   128
;  *                ADCŴ1   FPGAŴ1
;  *       3)̹:ʱ2sɼAN2AN3ѹADֵ(λ)ͨUARTӡ
;  *                  ˲20Σͨ궨USER_FILTERING޸
;  *                  UARTӡʽ0x5A 8λ 8λ 8λ 0xA5
;  *       עԿʹPDT1(P00)PCK1(P01)
;  *       עѹСLDOѹСڲοѹ
******************************************************************************/

#include "user.h"

u16 i;
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     //FCPU 4M
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BACK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BACK0();
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : ADC_Init
;  *    @Description         : ADCʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  *1)ADֵ
;  *    ADֵλΪλ23λΪλλΪ0ʾΪ1Ǹ
;  *    ڸʱλΪ0ADֵΪ23λ
;  *                        СڸʱλΪ1ADֵΪ23λĲ
;  *0x8a5a5a    λΪ1Ǹ23λȡ1ADֵΪ0x75a5a6
;  *    0x765432    λΪ0ADֵ䣬Ϊ0x765432
;  *2)
;  *    : HIRC/24/128 = 2604Hz
;  *    ѹ: VIN = V+ - V-  
;  *    VIN = ADֵ * οѹ / 0x7fffff / ADCŴ / FPGAŴ
;  *3)˽ӵأαƽADʹ
;  ***********************************************/
void ADC_Init(void)
{
    /*1.IOΪģ*/
    OEP1 &= DEF_CLR_BIT2;                                       //P12D
    OEP1 &= DEF_CLR_BIT3;                                       //P13D
    P1ADCR |= DEF_SET_BIT2 | DEF_SET_BIT3;                      //ʹģ⹦

    /*2.ADC*/
    ADCR0 |= DEF_SET_BIT5;                                      //ʹVIR
    ADCR0 |= DEF_SET_BIT3 | DEF_SET_BIT2 | DEF_SET_BIT0;        //ʹLDO2.8V
    ADCR1 |= DEF_SET_BIT6 | DEF_SET_BIT3 | DEF_SET_BIT1;        //ѡοѹΪ0.5 VLDOPGAŴ1ADCŴ1
    ADCR2 |= DEF_SET_BIT4 | DEF_SET_BIT0;                       //ʱHIRC/241282604Hz
    ADCR3 = 0xC7;                                               //PGAն CHOPƵFdac/1024
    ADCR4 &= 0x00;
    ADCR4 |= DEF_SET_BIT5 | DEF_SET_BIT1 | DEF_SET_BIT0;        //AN2AN3
    
    /*3.ʹADC*/
    ADEN = 1;                                                   //ʹ
}
/************************************************
;  *    @Function Name       : ADC_Get_Value_Average
;  *    @Description         : ת
;  *    @IN_Parameter        : ͨ
;  *    @Return parameter    : ADCֵ
;  ***********************************************/   
u32 ADC_Get_Value_Average(u8 P_CHX,u8 N_CHX)
{
    ADC_filtering = 0;
    get_adc_value_temp = 0;
    adc_value_buf_M = 0;
   	adc_value_buf_N = 0;

    ADCR4 &= 0x00;
    ADCR4 |= (P_CHX << 4) | N_CHX;                                              //ͨ
    for(ADC_filtering = 0;ADC_filtering < USER_FILTERING;ADC_filtering ++)
    {
        ADCONEN = 1;                                                            //ת
        ADIF = 0;
        while(ADIF == 0);                                                       //ȴת
        ADIF = 0;
        if(F_Change_Channel)                                                    //лͨʱ־λ1
        {
            F_Change_Channel = 0;
            ADCONEN = 0;                                                        //лͨرת
        }

        get_adc_value_temp = ADRH;
        get_adc_value_temp = (get_adc_value_temp << 8) | ADRM;
        get_adc_value_temp = (get_adc_value_temp << 8) | ADRL;
            
        if(ADC_filtering < 2)
        {
            continue;                                                           //ǰν
        }
        if(get_adc_value_temp & 0x800000)//
        {
            get_adc_value_temp = 0xFFFFFF - get_adc_value_temp + 1 ;
            adc_value_buf_M += get_adc_value_temp;
        }
        else
        {
            adc_value_buf_N += get_adc_value_temp;
        }
    }
    if(adc_value_buf_M > adc_value_buf_N)//
    {
        get_adc_value_temp = (adc_value_buf_M - adc_value_buf_N)/(USER_FILTERING - 2);          //ƽ
        get_adc_value_temp = 0xFFFFFF - get_adc_value_temp + 1 ;
    }
    else
        get_adc_value_temp = (adc_value_buf_N - adc_value_buf_M)/(USER_FILTERING - 2);          //ƽ
    return get_adc_value_temp;
}
/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : ʱ0ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void TIMER0_INT_Init(void)
{
    T0CR |= DEF_SET_BIT1;           //ʱģʽ,CPU,4Ƶ
    T0CNTH = 0x27;
    T0CNTL = 0x10 - 1;
    T0LOADH = 0x27;                 //1ms
    T0LOADL = 0x10 - 1;
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @Function Name       : UART_Init
;  *    @Description         : UARTʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void UART_Init(void)
{
    OEP0 &= DEF_CLR_BIT2;           //TX
    OEP0 &= DEF_CLR_BIT3;           //RX
    PUP0 |= DEF_SET_BIT2;           //TX
    PUP0 |= DEF_SET_BIT3;           //RX

    IOP0 |= DEF_SET_BIT2;           //TX
    IOP0 |= DEF_SET_BIT3;           //RX

    URTCR0 = 0x40;                  //ʱӷƵ1:1
    URTCR1 = 0;
    URTCR2 = 0;
    URTBR = 68;                     //115200

    URTEN = 1;                      //ʹUART
}
/************************************************
;  *    @Function Name       : UART_Send_Byte
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/ 
void UART_Send_Byte(u8 dat)
{
    UREN = 0;
    RXIE = 0;

    URTDR = dat;
    while(0 == TXIF)                //ȴǰݷ
    {
        ClrWdt();                   //忴Ź
    }
    TXIF = 0;

    UREN = 1;
    RXIE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    UART_Init();
    ADC_Init();
    TIMER0_INT_Init();
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
    while(1)
    {   
        if(F_TIMER_2S == SET)
        {
            F_TIMER_2S = 0;
            get_adc_value = ADC_Get_Value_Average(2,3);
            get_adc_adrh = get_adc_value >> 16;
            get_adc_adrm = get_adc_value >> 8;
            get_adc_adrl = get_adc_value;
            UART_Send_Byte(0x5A);
            UART_Send_Byte(get_adc_adrh);
            UART_Send_Byte(get_adc_adrm);
            UART_Send_Byte(get_adc_adrl);
            UART_Send_Byte(0xA5);
        }
        
    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  

    if(T0IE & T0IF)
    {
        T0IF = 0;
        timer_count ++;
        if(timer_count == 200)
        {
            timer_count = 0;
            F_TIMER_2S = SET;
            P15D = !P15D;
        }
    }

__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}
/************************************************
;  *    @Function Name       : SinoDIV
;  *    @Description         : ų
;  *    @IN_Parameter        : divisor()dividend()
;  *    @Return parameter    : quotient()
;  ***********************************************/   
uint32_t SinoDIV(uint32_t dividend,uint32_t divisor)
{
    uint32_t    quotient;
    uint32_t    DIV_HighBit=0x80000000;
    uint8_t     counter;

    remainder = 0;
    quotient = 0;
    if(divisor != 0) {
        counter = 1;
        while((divisor & DIV_HighBit) == 0) {
            divisor <<= 1;
            counter++;
        }
        do {
            quotient <<= 1;
            if(divisor <= dividend) {
                dividend -= divisor;
                quotient |= 1;
            }
            divisor >>= 1;
        } while(--counter != 0);
        remainder = dividend;
    }
    return quotient;
    }
/**************************** end of file *********************************************/