/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------ժҪ---------------------------------
;  *              ʱ-Ƶ ÿ10msһ
;  *              T0   P13 100uSת
;  *              T1   P14 10mSת ޸HIRCCAL ΢CPUʱ
******************************************************************************/

#include "user.h"

u16 i;
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0 ++) 
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
    RBS = 1;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0; 
    RBS = 0;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : ʱ0ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void TIMER0_INT_Init(void)
{
    T0CR |= DEF_SET_BIT1;     //ʱģʽ,CPU,4Ƶ
    T0CNTH = 0;
    T0CNTL = 100 - 1;
    T0LOADH = 0;              //100us
    T0LOADL = 100 - 1;
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @Function Name       : TIMER1_INT_Init
;  *    @Description         : ʱ1ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void TIMER1_INT_Init(void)
{
    T1CR |= DEF_SET_BIT1;     //ʱģʽ,CPU,4Ƶ
    T1CNTH = 0x03;
    T1CNTL = 0xE8 - 1;
    T1LOADH = 0x03;           //1ms
    T1LOADL = 0xE8 - 1;
    T1EN = 1;
    T1IE = 1;
}
/************************************************
;  *    @Function Name       : HIRC_Adjust
;  *    @Description         : Ƶ΢
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void HIRC_Adjust(void)
{
    if (F_PFRCR_ADD_DEC)
    {
        if (g_hirc_temp < g_hirc_back)
        {
            g_hirc_temp ++;
        }else F_PFRCR_ADD_DEC = 0;     //ӵg_hirc_back   ʼݼ
    }
    else
    {
        if(g_hirc_temp > 0)
        {
            g_hirc_temp --;
        }else F_PFRCR_ADD_DEC = 1;     //0  ʼ
    }
    HIRCCAL = g_hirc_temp;             //޸΢Ĵ
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    TIMER1_INT_Init();
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
    g_hirc_back = HIRCCAL;             //Ƶ΢У׼λ
    g_hirc_temp = g_hirc_back;
    while(1)
    {   
        if (F_TIMER_10ms)          //10mS޸һ
        {
            F_TIMER_10ms = RESET;
            HIRC_Adjust();             //Ƶ΢
        }

    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  

    /**********  T0  **********/
    if(T0IE & T0IF)
    {
        T0IF = 0;
        P13D = !P13D;
    }
    /**********  T1  **********/
    if(T1IE & T1IF)
    {
        T1IF = 0;
        timer1_cnt1 ++;
        if(timer1_cnt1 == 10)
        {
            timer1_cnt1 = 0;
            F_TIMER_10ms = 1;
            P14D = !P14D;
        }
    }

__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}


/**************************** end of file *********************************************/