/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------ժҪ---------------------------------
;  *                IIC_Master
;  *                SCL P03
;  *                SDA P02
;  *                ܣ
;  *                    IIC_SlaveӻͨѶ
;  *                    1)ӻдIIC_test_buff_data
;  *                    2)ȡӻݣIIC_test_buff
;  *                    3)鳤Ĭ20ͨ궨IIC_DATA_LEN޸
;  *                עԿʹPDT1(P00)PCK1(P01)
******************************************************************************/

#include "user.h"

u16 i;
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BACK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BACK0();
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : IIC_Init
;  *    @Description         : IICʼ
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/  
void IIC_Init(void)
{
    OEP0 &= DEF_CLR_BIT2;//SCL
    OEP0 &= DEF_CLR_BIT3;//SDA

    IOP0 |= DEF_SET_BIT2 | DEF_SET_BIT3;
    
    IICCR0 = 0x01;            //ģʽ100KbpsͬԶSTOPʹ0IOѡIICר
    IICCR1 = 0x00;
    IICSR = 0x00;
    IICDR = 0x00;
    IICAR = 0xA0;            //͵ַ
    IICAAR = 0x00;
    IICAMR = 0x00;
    
    IICIF = 0;
    IICIE = 1;               //IICжʹ
    IICEN = 1;               //ʹIIC
}
/************************************************
;  *    @Function Name       : IIC_Start
;  *    @Description         : IICʼź
;  *    @IN_Parameter        : ӻַ /дָ
;  *    @Return parameter    :
;  ***********************************************/  
void IIC_Start(u8 R_Slave_addr)
{
    IICAR = R_Slave_addr;
    MTSAA = 1;                      //ʼź
    while(F_IIC_DONE == RESET);      //˳ж
    F_IIC_DONE = RESET;
}
/************************************************
;  *    @Function Name       : IIC_Write_Byte
;  *    @Description         : дһ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void IIC_Write_Byte(u8 data)
{
    if(RACKF == 0)
    {
        IICDR = data;
        MTDTA = 1;
        while(F_IIC_DONE == RESET);
        F_IIC_DONE = RESET;
    }
    else
    {
        IIC_Stop();
    }
}
/************************************************
;  *    @Function Name       : IIC_Read_Byte
;  *    @Description         : һ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/  
u8 IIC_Read_Byte(void)
{
    if(RACKF == 0)
    {
        if(len == IIC_DATA_LEN-1)//ȡһʱNACK
        {
            TACKS = 1; 
        }
        else
        {
            TACKS = 0; 
        }
        MRDTA = 1;
        while(F_IIC_DONE == RESET);
        F_IIC_DONE = RESET;
        temp = IICDR;
        return temp;
    }
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void IIC_Stop(void)
{
    MTSTP = 1;              //STOPź
    while(F_IIC_DONE== RESET);
    F_IIC_DONE = RESET;
}
/************************************************
;  *    @          : Sys_Init
;  *    @˵            : ϵͳʼ
;  *    @        : 
;  *    @ز        :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    IIC_Init();
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
    /*******************ӻд***************************/
    IIC_Start(0xA0);                //ӻַд
    for(len = 0;len < IIC_DATA_LEN;len++)
    {
        IIC_Write_Byte(IIC_test_buff_data[len]);
        delay(100);
    }
    IIC_Stop();
    delay(5000);
    /*******************Ӵӻȡ***************************/
    IIC_Start(0xA1);                //ӻַ
    for(len = 0;len < IIC_DATA_LEN;len++)
    {
       IIC_test_buff[len] = IIC_Read_Byte();
       delay(100);
    }
    IIC_Stop();

    Nop();

    while(1)
    {   
    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  

    /**********  IIC  **********/
    if(IICIF)
    {
        IICIF  = 0;
        F_IIC_DONE = SET;
    }

__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}


/**************************** end of file *********************************************/