/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------ժҪ---------------------------------
;  *                IIC_Slave(Ӳӻ)
;  *                ͨѶʱٶȽϿʱ֧ʱչ
;  *                ӻַ0xA0
;  *                IIC_SCL:P03
;  *                IIC_SDA:P02
;  *                ܣ
;  *                    IIC ͨѶ
;  *                    1)յдݣiic_data_buffer
;  *                    2)յiic_data_buffer
;  *                    3)鳤Ĭ30ͨ궨IIC_DATA_LEN޸
;  *                    4)iic_tx_idx>iic_rx_idxʱִӻݳʼеֵ(Χ0x80~0x9D)
;  *                עʹPDT1(P00)PCK1(P01)Կ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    u16 i;
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BACK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BACK0();
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : IIC_Init
;  *    @Description         : IICʼ
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/  
void IIC_Init(void)
{
    OEP0 &= DEF_CLR_BIT2;    //SDA
    OEP0 &= DEF_CLR_BIT3;    //SCL

    IOP0 |= DEF_SET_BIT2 | DEF_SET_BIT3;
    

    IICCR0 = 0x51;              //ӻģʽ100KbpsͬԶSTOPʹ0IOѡIICר
    IICSR = 0x00;
    IICDR = 0x00;
    IICAR = 0xA0;               //ӻַ
    IICAAR = 0x00;
    IICAMR = 0x00;
    
    TACKS = 0;
    
    IICIF = 0;
    IICIE = 1;                  //IICжʹ
    IICEN = 1;                  //ʹIIC
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    IIC_Init();
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
    while(1)
    {  

    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  

    //жʹ飬ҪFSRĴ
    FSR0_Buff=FSR0;
    FSR1_Buff=FSR1;

/*PFLAGѱGPR1洢ѡλٲRBS*/
    /**********  IIC  **********/
    if(IICIF)
    {
    IIC_CODE:
        if(SADMF)              //ַƥ䣬ӦλTACKSĬΪ0,Ϊ֤ͨŴӻNACK
        {
            iic_tx_idx = IIC_DATA_BUFF_ADDR;                    
            iic_rx_idx = IIC_DATA_BUFF_ADDR;           
        }
        if(SCMDF==0)           //д
        {
            if(SADMF==0)       //ӻʱ
            {
                if((iic_rx_idx-IIC_DATA_BUFF_ADDR) < IIC_DATA_LEN)
                {
                    // iic_data_buffer[iic_rx_idx] = IICDR;

                    //ͨѰַʽ߷Ч
                    FSR0 = iic_rx_idx;  
                    INDF0=IICDR;

                    iic_rx_idx++;
                }
            }    
        }else                  //
        {
            if((iic_tx_idx-IIC_DATA_BUFF_ADDR) < IIC_DATA_LEN)    
            {
                // IICDR = iic_data_buffer[iic_tx_idx];

                //ͨѰַʽ߷Ч
                FSR0 = iic_tx_idx;
                IICDR=INDF0;
                
                iic_tx_idx++;
            }else
            {
                IICDR = 0xFF;    //
            }
        }
        IICIF = 0;
    }
    if(IICIF)
    {
        goto IIC_CODE;
    }

    //жʹ飬ҪSFRĴ
    FSR0=FSR0_Buff;
    FSR1=FSR1_Buff;

__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}


/**************************** end of file *********************************************/