/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------ժҪ---------------------------------
;  *                    INT
;  *                    INT0  P16   ½شתP13
;  *                    INT1  P17   شתP14
******************************************************************************/

#include "user.h"

u16 i;
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0 ++) 
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
    RBS = 1;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0; 
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : INT_Init
;  *    @Description         : ⲿжϳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void INT_Init(void)
{
    OEP1 &= DEF_CLR_BIT7;       //P16(INT0) P17(INT1) in
    OEP1 &= DEF_CLR_BIT6;
    PUP1 |= DEF_SET_BIT6;       //P16(INT0) up
    PDP1 |= DEF_SET_BIT7;       //P17(INT1) down

    MCR |= DEF_SET_BIT2;        //INT0 ½ش  INT1 ش
    INT0IE = 1;
    INT1IE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    INT_Init();
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
    while(1)
    {   

    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  

    /**********  INT0  **********/
    if(INT0IE & INT0IF)
    {
        INT0IF = 0;
        P13D = !P13D;
    }
    /**********  INT1  **********/
    if(INT1IE & INT1IF)
    {
        INT1IF = 0;
        P14D = !P14D;
    }

__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}


/**************************** end of file *********************************************/