/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------ժҪ---------------------------------
;  *                LVDⲿ磩
;  *                VDDѹ3.2V(LVR2.4V),P13,֮ 
******************************************************************************/

#include "user.h"

u16 i;
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BACK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BACK0();
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : LVD_Init
;  *    @Description         : LVDʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void LVD_Init(void)
{
    LVDCR = 0x00;
    LVDCR|= DEF_SET_BIT6 | DEF_SET_BIT5 | DEF_SET_BIT4;       //1110 3.2V
       LVDEN = 1;
    LVDIE=1;    //ʹLVDж
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    LVD_Init();
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
    HFEN=0;
    LFEN=1;                            //رոƵ,ڲƵʼչ
    while(1)
    {   
        if(LVDF)                       //VDDС趨ֵ
        {
            P13D=1;
        }else P13D=0;  
    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  

    /**********  LVD  **********/
    if((LVDIF)&&(LVDIE))
    {
        LVDIF = 0;
        P12D =! P12D;
    }
__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}


/**************************** end of file *********************************************/