/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------  ---------------------------------
;  *                   ʱʹȫֱ                       
******************************************************************************/
#ifndef USER
#define USER
#include "MS32F7223.h"

/*****************************************************************
;       Function : Define variables
;*****************************************************************/
#define u8 unsigned char
#define u16 unsigned int
#define u32 unsigned long int
#define uint8_t  unsigned char
#define uint16_t unsigned int
#define uint32_t unsigned long int

#define DEF_SET_BIT0                0x01
#define DEF_SET_BIT1                0x02
#define DEF_SET_BIT2                0x04
#define DEF_SET_BIT3                0x08
#define DEF_SET_BIT4                0x10
#define DEF_SET_BIT5                0x20
#define DEF_SET_BIT6                0x40
#define DEF_SET_BIT7                0x80

#define DEF_CLR_BIT0                0xFE
#define DEF_CLR_BIT1                0xFD
#define DEF_CLR_BIT2                0xFB
#define DEF_CLR_BIT3                0xF7
#define DEF_CLR_BIT4                0xEF
#define DEF_CLR_BIT5                0xDF
#define DEF_CLR_BIT6                0xBF
#define DEF_CLR_BIT7                0x7F

#define SET                         1
#define RESET                       0
#define PASS                        1
#define FAIL                        0

#define USER_FILTERING              20

#define     BACK0()          RBS=0    //ַ0ҳ
#define     BACK1()          RBS=1    //ַ1ҳ  
//===============Field Protection Variables===============
__at 0x007 u8 abuf;          //жϱıڴ洢 0
__at 0x008 u8 statusbuf;
//===============Global Variable===============
u8 ADC_filtering;
u32 get_adc_value_temp,adc_value_buf,adcmax,adcmin;
u32 get_adc_value,adc_value_buf_M,adc_value_buf_N;
u8 get_adc_adrh,get_adc_adrm,get_adc_adrl;
uint8_t     remainder;
u8 timer_count;

//===============Global Function===============
void CLR_RAM(void);
void IO_Init(void);
void UART_Init(void);
void UART_Send_Byte(u8 dat);
uint32_t SinoDIV(uint32_t dividend,uint32_t divisor);
void ADC_Init(void);
u32 ADC_Get_Value_Average(u8 P_CHX,u8 N_CHX);
void TIMER0_INT_Init(void);
void delay(uint16_t num);

void Sys_Init(void);

//============Define  Flag=================
typedef union {
    unsigned char byte;
    struct
    {
        u8 bit0 : 1;
        u8 bit1 : 1;
        u8 bit2 : 1;
        u8 bit3 : 1;
        u8 bit4 : 1;
        u8 bit5 : 1;
        u8 bit6 : 1;
        u8 bit7 : 1;
    } bits;
}bit_flag;
volatile bit_flag flag1;

#define     F_TIMER_2S          flag1.bits.bit0
#define     F_Change_Channel    flag1.bits.bit1

#endif

/**************************** end of file *********************************************/
