/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------ժҪ---------------------------------
;  *                      EEPROM
;  *                1)EEPROMȫռд0-FF,ٶUARTӡ
;  *                2)EEPROM0ҳݣٶȡȫռ䣬UARTӡ
;  *                ĬֶģʽֽдԶģʽǰҳ
;  *                ͨUSER_HANDMODEUSER_PAGEWRITE궨޸
;  *                UARTӡݣ0xA5ͷ 0x5Aβ
;  *                עڣTX0(P02) RX0(P03) 115200
******************************************************************************/

#include "user.h"

u16 i;
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BACK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BACK0();
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0x00;        //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : UART_Init
;  *    @Description         : UARTʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void UART_Init(void)
{
    OEP0 &= DEF_CLR_BIT2;           //TX
    OEP0 &= DEF_CLR_BIT3;           //RX
    PUP0 |= DEF_SET_BIT2;           //TX
    PUP0 |= DEF_SET_BIT3;           //RX

    IOP0 |= DEF_SET_BIT2;           //TX
    IOP0 |= DEF_SET_BIT3;           //RX

    URTCR0 = 0x40;                  //ʱӷƵ1:1
    URTCR1 = 0;
    URTCR2 = 0;
    URTBR = 68;                     //115200

    URTEN = 1;                      //ʹUART
}
/************************************************
;  *    @Function Name       : UART_Send_Byte
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void UART_Send_Byte(u8 dat)
{
    UREN = 0;
    RXIE = 0;

    URTDR = dat;
    while(0 == TXIF)                //ȴǰݷ
    {
        ClrWdt();                   //忴Ź
    }
    TXIF = 0;

    UREN = 1;
    RXIE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    UART_Init();
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
    /*************ȫռд***********************/
    for(g_count1 = 0; g_count1 < 0x10;g_count1 ++)
    {
#if(USER_PAGEWRITE == 0)
        //ֽд
        for(g_count2 = 0; g_count2 < 0x10;g_count2 ++)
        {
    #if(USER_HANDMODE == 1)
            EEPROM_Handmode_Write_Byte(0 , g_count1 , g_count2 , EEPROM_test_num);  //д
    #else
            EEPROM_Autotmode_Write_Byte(0 , g_count1 , g_count2 ,0x003E); 
    #endif
            EEPROM_test_num ++;
        }
#else
        //ҳд
        for(g_count2 = 0;g_count2 < 16;g_count2 ++)
        {
            data_test[g_count2] = EEPROM_test_num ++;
        }
    #if(USER_HANDMODE == 1)
        EEPROM_Handmode_Write_PAGE(0,g_count1,data_test);
    #else
        EEPROM_Automode_Write_PAGE(0,g_count1,0x0050);                               //Զģʽд 0x0050Ϊdata_testʼַ
    #endif
#endif   
    }
    /*************ȫռȡݲuartӡ***********************/
    UART_Send_Byte(0xA5);
    for(g_count1 = 0; g_count1 < 0x10;g_count1 ++)
    {
        for(g_count2 = 0; g_count2 < 0x10;g_count2 ++)
        {   
            EEPROM_test_buff = EEPROM_Read_Byte(0 , g_count1 , g_count2);       //ȡ
            UART_Send_Byte(EEPROM_test_buff);
        }
    }
    UART_Send_Byte(0x5A);

    /****************00ҳ16*****************/
    //ҳ
    //ûֲV1.179ҳ ע2:洢ΪֵڸûʱEEPROMڴ洢ûУͣԱ֤
    EEPROM_Handmode_ERASE_PAGE(0,0);
    /*****************ٴζȡݲuartӡ***********************/
    UART_Send_Byte(0xA5);
    for(g_count1 = 0; g_count1 < 0x10;g_count1 ++)
    {
        for(g_count2 = 0; g_count2 < 0x10;g_count2 ++)
        {   
            EEPROM_test_buff = EEPROM_Read_Byte(0 , g_count1 , g_count2);       //ȡ
            UART_Send_Byte(EEPROM_test_buff>>8);
            UART_Send_Byte(EEPROM_test_buff);
        }
    }
    UART_Send_Byte(0x5A);
    
    while(1)
    {   
        Nop();
    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  

    /**********  T0  **********/
    // if(T0IE & T0IF)
    // {
    //     T0IF = 0;
    //     P13D = !P13D;
    // }

__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}
/************************************************
;  *    @Function Name       : EEPROM_Read_Byte
;  *    @Description         : ڲEEPROM1ֽ
;  *    @IN_Parameter        : ַ
;  *    @Return parameter    : 
;  ***********************************************/   
uint16_t EEPROM_Read_Byte(uint8_t sar , uint8_t par, uint8_t war)
{
    IAPCR0 = 0x86;                  //ʹIAPѡwordѡEE
    IAPSAR = sar;                   //ַ
    IAPPAR = par;                   //ҳַ
    IAPWAR = war;                   //ֵַ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x40;                  // EE 
    Nop();
    Nop();
    while(IAPREAD)                  // EE дǷ
    {
        ClrWdt();                   //忴Ź
    }
    GIE = 1;
    EE_READ = (IAPDRH << 8) | IAPDRL;
    return EE_READ;
}
/************************************************
;  *    @Function Name       : EEPROM_Handmode_Write_Byte
;  *    @Description         : ֶģʽֽд
;  *    @IN_Parameter        : ַ ҳַ ֵַ 
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Handmode_Write_Byte(uint8_t sar , uint8_t par, uint8_t war, uint16_t data)
{
    IAPCR0 = 0x86;                  //ʹIAPѡwordѡEE
    IAPSAR = sar;                   //ַ
    IAPPAR = par;                   //ҳַ
    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ
    IAPWAR = war;                   //ֵַ

    IAPDRH = (data >> 8) & 0xFF;
    IAPDRL = data & 0xFF;
    IAPBUFL = 1;                    //ݵ
    while(IAPBUFL);                 //ȴ
    GIE = 0;

    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x03;                  //  дݲ
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT);                 // EE дǷ

}
/************************************************
;  *    @Function Name       : EEPRROM_Handmode_Write_PAGE
;  *    @Description         : ֶģʽҳд
;  *    @IN_Parameter        : ַ ҳַ 
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Handmode_Write_PAGE(uint8_t sar , uint8_t par, uint16_t *data)
{
    IAPSAR = sar;                   //ַ
    IAPPAR = par;                   //ҳַ
    IAPCR0 = 0x8A;                  //ʹIAPѡpageѡEE
    IAPBUFC = 1;                    //
    while(IAPBUFC)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
    IAPWAR = 0; 
    for(cnt = 0;cnt < 16;cnt ++)    
    {
        IAPDRH = data[cnt] >> 8;
        IAPDRL = data[cnt];
        IAPBUFL = 1;                //ݵ
        while(IAPBUFL)              //ȴ
        {
            ClrWdt();               //忴Ź
        }
        IAPWAR ++;
    }
    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }

    IAPBUFC = 1;                    //
    while(IAPBUFC)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
    IAPWAR = 0;
    IAPCR0 = 0x8A;
    for(cnt = 0;cnt < 16;cnt ++)
    {
        IAPDRH = data[cnt] >> 8;
        IAPDRL = data[cnt];
        IAPBUFL = 1;                //ݵ
        while(IAPBUFL)              //ȴ
        {
            ClrWdt();               //忴Ź
        }
        IAPWAR ++;
    }
    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x01;                  //д
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴд
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @Function Name       : EEPROM_Handmode_ERASE_word
;  *    @Description         : ֶģʽֽڲ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Handmode_ERASE_word(uint8_t sar , uint8_t par, uint8_t war)
{
    IAPCR0 = 0x86;                  //ʹIAPѡwordѡEEPROM
    IAPSAR = sar;
    IAPPAR = par;
    IAPWAR = war;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @Function Name       : EEPROM_Handmode_ERASE_PAGE
;  *    @Description         : ֶģʽҳ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Handmode_ERASE_PAGE(uint8_t sar , uint8_t par)
{
    IAPCR0 = 0x8A;                  //ʹIAPѡҳѡEEPROM
    IAPSAR = sar;
    IAPPAR = par;
    IAPWAR = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ
    for(cnt = 0;cnt < 16;cnt ++)    //һҳ16
    {
        IAPDRH = 0;
        IAPDRL = 0;

        IAPBUFL = 1;                //ݵ
        while(IAPBUFL)              //ȴ
        {
            ClrWdt();               //忴Ź
        }
        IAPWAR ++;
    }

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }

}
/************************************************
;  *    @Function Name       : EEPROM_Handmode_ERASE_SECTOR
;  *    @Description         : ֶģʽ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Handmode_ERASE_SECTOR(uint8_t sar)
{
    IAPCR0 = 0x92;                  //ʹIAPѡѡEEPROM
    IAPSAR = sar;
    IAPPAR = 0;
    IAPWAR = 0;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @Function Name       : EEPROM_Autotmode_Write_Byte
;  *    @Description         : Զģʽֽдʼַ2ֽдFLSAH
;  *    @IN_Parameter        : ַ ҳַ ֵַ  дݵĵַ
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Autotmode_Write_Byte(uint8_t sar , uint8_t par, uint8_t war, uint16_t data_addr)
{
    IAPCR0 = 0xC6;                  //ʹIAPѡwordѡEEPROM
    IAPSAR = sar;                   //ַ
    IAPPAR = par;                   //ҳַ
    IAPWAR = war;                   //ֵַ

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ
    IAPWAR = war;                   //ֵַ

    IAPDRH = data_addr >> 8;
    IAPDRL = data_addr;
    IAPBUFL = 1;                    //ݵ
    while(IAPBUFL);                 //ȴ
    GIE = 0;

    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x03;                  //  д
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT);                 // EE дǷ
}
/************************************************
;  *    @Function Name       : EEPROM_Automode_Write_PAGE
;  *    @Description         : Զģʽҳдʼַ32ֽдEEPROM
;  *    @IN_Parameter        : ַ  ҳַ  дݵʼַ
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Automode_Write_PAGE(uint8_t sar , uint8_t par, uint16_t data_addr)
{
    IAPCR0 = 0xCA;                  //ʹIAPѡpageѡEE
    IAPSAR = sar;                   //ַ
    IAPPAR = par;                   //ҳַ
    IAPWAR = 0; 

    //д
    IAPBUFC = 1;                    //
    while(IAPBUFC)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
    IAPDRH = data_addr >> 8;
    IAPDRL = data_addr;
    IAPBUFL = 1;                    //ݵ
    while(IAPBUFL)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x03;                  //д
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴд
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @Function Name       : EEPROM_Automode_ERASE_word
;  *    @Description         : Զģʽֽڲ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Automode_ERASE_word(uint8_t sar , uint8_t par, uint8_t war)
{
    IAPCR0 = 0xC6;                  //ʹIAPѡwordѡEEPROM
    IAPSAR = sar;
    IAPPAR = par;
    IAPWAR = war;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @Function Name       : EEPROM_Automode_ERASE_PAGE
;  *    @Description         : Զģʽҳ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Automode_ERASE_PAGE(uint8_t sar , uint8_t par)
{
    IAPCR0 = 0xCA;                  //ʹIAPѡҳѡEEPROM
    IAPSAR = sar;
    IAPPAR = par;
    IAPWAR = 0;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @Function Name       : EEPROM_Automode_ERASE_SECTOR
;  *    @Description         : Զģʽ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void EEPROM_Automode_ERASE_SECTOR(uint8_t sar)
{
    IAPCR0 = 0xD2;                  //ʹIAPѡѡEEPROM
    IAPSAR = sar;
    IAPPAR = 0;
    IAPWAR = 0;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/**************************** end of file *********************************************/