/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.1
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      IAP
;  *                1ӵ50ҳ0ַʼд32ݣٶʹUARTӡ
;  *                251ҳ16ݣٴζȡݲuartӡ
;  *                ĬֶģʽֽдԶģʽǰҳ
;  *                ͨUSER_HANDMODEUSER_PAGEWRITE궨޸
;  *                UARTӡݣ0xA5ͷ 0x5Aβ
;  *                עڣTX0(P02) RX0(P03) 115200
******************************************************************************/

#include "user.h"

u16 i;
/************************************************
;  *    @          : delay
;  *    @˵            : ȷʱ4M Լ10us
;  *    @        : ʱʱ
;  *    @ز        :
;  ***********************************************/
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        : 
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BACK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BACK0();
}
/************************************************
;  *    @          : IO_Init
;  *    @˵            : ͨIO
;  *    @        : 
;  *    @ز        :
;  ***********************************************/ 
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @            : UART_Init
;  *    @˵              :   IO
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void UART_Init(void)
{
    OEP0 &= DEF_CLR_BIT2;           //TX
    OEP0 &= DEF_CLR_BIT3;           //RX
    PUP0 |= DEF_SET_BIT2;           //TX
    PUP0 |= DEF_SET_BIT3;           //RX

    IOP0 |= DEF_SET_BIT2;           //TX
    IOP0 |= DEF_SET_BIT3;           //RX

    URTCR0 = 0x40;                  //ʱӷƵ1:1
    URTCR1 = 0;
    URTCR2 = 0;
    URTBR = 68;                     //115200

    URTEN = 1;                      //ʹUART
}

/************************************************
;  *    @            : UART_Send_Byte
;  *    @˵              : 
;  *    @          : 
;  *    @ز          :
;  ***********************************************/
void UART_Send_Byte(u8 dat)
{
    UREN = 0;
    RXIE = 0;

    URTDR = dat;
    while(0 == TXIF)                //ȴǰݷ
    {
        ClrWdt();                   //忴Ź
    }
    TXIF = 0;

    UREN = 1;
    RXIE = 1;
}
/************************************************
;  *    @          : Sys_Init
;  *    @˵            : ϵͳʼ
;  *    @        : 
;  *    @ز        :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    UART_Init();
    GIE  = 1;        
}
/************************************************
;  *    @          : mian
;  *    @˵            : 
;  *    @        : 
;  *    @ز        :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    /*************ӵ50ҳ0ַʼд32***********************/
    for(g_count1 = 0; g_count1 < 2;g_count1 ++)
    {
#if(USER_PAGEWRITE == 0)
        // ֽд
        for(g_count2 = 0; g_count2 < 0x10;g_count2 ++)
        {
    #if(USER_HANDMODE == 1)
            FLASH_Handmode_Write_Byte(5 , g_count1 , g_count2 , FLASH_test_num);    //ֶģʽд
    #else
            FLASH_Autotmode_Write_Byte(5 , g_count1 , g_count2 ,0x003E);            //Զģʽд  0x003eΪFLASH_test_numַ
    #endif
            FLASH_test_num ++;
        }
#else
        // ҳд
        for(g_count2 = 0;g_count2 < 16;g_count2 ++)                                 //鸳ֵ
        {
            data_test[g_count2] = FLASH_test_num ++;
        }
    #if(USER_HANDMODE == 1)
        FLASH_Handmode_Write_PAGE(5,g_count1,data_test);                            //ֶģʽд
    #else
        FLASH_Automode_Write_PAGE(5,g_count1,0x0050);                               //Զģʽд 0x0050Ϊdata_testʼַ
    #endif   
#endif 
    }
    /*****************ȡдݲuartӡ***********************/
    UART_Send_Byte(0xA5);
    for(g_count1 = 0; g_count1 < 2;g_count1 ++)
    {
        for(g_count2 = 0; g_count2 < 0x10;g_count2 ++)
        {   
            FLASH_test_buff = FLASH_Read_Byte(5 , g_count1 , g_count2);       //ȡ
            UART_Send_Byte(FLASH_test_buff>>8);
            UART_Send_Byte(FLASH_test_buff);
        }
    }
    UART_Send_Byte(0x5A);
    /****************51ҳ16*****************/
    //ҳ
    //ûֲV1.179ҳ ע2:洢ΪֵڸûʱEEPROMڴ洢ûУͣԱ֤
    FLASH_Handmode_ERASE_PAGE(5,1);
    /*****************ٴζȡݲuartӡ***********************/
    UART_Send_Byte(0xA5);
    for(g_count1 = 0; g_count1 < 2;g_count1 ++)
    {
        for(g_count2 = 0; g_count2 < 0x10;g_count2 ++)
        {   
            FLASH_test_buff = FLASH_Read_Byte(5 , g_count1 , g_count2);       //ȡ
            UART_Send_Byte(FLASH_test_buff>>8);
            UART_Send_Byte(FLASH_test_buff);
        }
    }
    UART_Send_Byte(0x5A);
    while(1)
    {   
        Nop();
    }
}

void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  

    /**********  T0  **********/
    // if(T0IE & T0IF)
    // {
    //     T0IF = 0;
    //     P13D = !P13D;
    // }

__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}
/************************************************
;  *    @            : FLASH_Read_Byte
;  *    @˵              : ڲFLASH1ֽ
;  *    @          : ַ ҳַ ֵַ
;  *    @ز          : 
;  ***********************************************/
uint16_t FLASH_Read_Byte(uint8_t sar , uint8_t par, uint8_t war)
{
    IAPCR0 = 0x84;                  //ʹIAPѡwordѡEE
    IAPSAR = sar;                   //ַ
    IAPPAR = par;                   //ҳַ
    IAPWAR = war;                   //ֵַ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x40;                  // EE 
    Nop();
    Nop();
    while(IAPREAD)                  // EE дǷ
    {
        ClrWdt();                   //忴Ź
    }
    GIE = 1;
    EE_READ = (IAPDRH << 8) | IAPDRL;
    return EE_READ;
}
/************************************************
;  *    @            : FLASH_Handmode_Write_Byte
;  *    @˵              : ֶģʽֽд
;  *    @          : ַ ҳַ ֵַ 
;  *    @ز          : 
;  ***********************************************/
void FLASH_Handmode_Write_Byte(uint8_t sar , uint8_t par, uint8_t war, uint16_t data)
{
   IAPCR0 = 0x84;                  //ʹIAPѡwordѡFLASH
   IAPSAR = sar;                   //ַ
   IAPPAR = par;                   //ҳַ
   IAPWAR = war;                   //ֵַ

   IAPBUFC = 1;                    //
   while(IAPBUFC);                 //ȴ
   IAPWAR = war;                   //ֵַ

   IAPDRH = data >> 8;
   IAPDRL = data;
   IAPBUFL = 1;                    //ݵ
   while(IAPBUFL);                 //ȴ
   GIE = 0;

   IAPPR = 0x5A;
   IAPPR = 0xA5;                   //
   IAPCR1 = 0x03;                  //  д
   Nop();
   Nop();
   GIE = 1;
   while(IAPSTAT);                 // дǷ
}
/************************************************
;  *    @            : FLASH_Handmode_Write_PAGE
;  *    @˵              : ֶģʽҳд
;  *    @          : ַ ҳַ 
;  *    @ز          : 
;  ***********************************************/
void FLASH_Handmode_Write_PAGE(uint8_t sar , uint8_t par, uint16_t *data)
{
    IAPCR0 = 0x88;                  //ʹIAPѡpageѡEE
    IAPSAR = sar;                   //ַ
    IAPPAR = par;                   //ҳַ

    // Ȳд룬ûֲV1.1 71ҳע
    IAPBUFC = 1;                    //
    while(IAPBUFC)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
    IAPWAR = 0;
    for(cnt = 0;cnt < 16;cnt ++)    //һҳ16
    {
        IAPDRH = data[cnt] >> 8;
        IAPDRL = data[cnt];
        IAPBUFL = 1;                //ݵ
        while(IAPBUFL)              //ȴ
        {
            ClrWdt();               //忴Ź
        }
        IAPWAR ++;
    }
    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }

    // д
    IAPBUFC = 1;                    //
    while(IAPBUFC)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
    IAPWAR = 0;
    for(cnt = 0;cnt < 16;cnt ++)    //һҳ16
    {
        IAPDRH = data[cnt] >> 8;
        IAPDRL = data[cnt];
        IAPBUFL = 1;                //ݵ
        while(IAPBUFL)              //ȴ
        {
            ClrWdt();               //忴Ź
        }
        IAPWAR ++;
    }
    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x01;                  //д
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴд
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @            : FLASH_Handmode_ERASE_word
;  *    @˵              : ֶģʽֽڲ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void FLASH_Handmode_ERASE_word(uint8_t sar , uint8_t par, uint8_t war)
{
    IAPCR0 = 0x84;                  //ʹIAPѡwordѡFLASH
    IAPSAR = sar;
    IAPPAR = par;
    IAPWAR = war;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @            : FLASH_Handmode_ERASE_PAGE
;  *    @˵              : ֶģʽҳ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void FLASH_Handmode_ERASE_PAGE(uint8_t sar , uint8_t par)
{
    IAPCR0 = 0x88;                  //ʹIAPѡҳѡFLASH
    IAPSAR = sar;
    IAPPAR = par;
    IAPWAR = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ
    for(cnt = 0;cnt < 16;cnt ++)    //һҳ16
    {
        IAPDRH = 0;
        IAPDRL = 0;

        IAPBUFL = 1;                //ݵ
        while(IAPBUFL)              //ȴ
        {
            ClrWdt();               //忴Ź
        }
        IAPWAR ++;
    }

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }

}
/************************************************
;  *    @            : FLASH_Handmode_ERASE_SECTOR
;  *    @˵              : ֶģʽ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void FLASH_Handmode_ERASE_SECTOR(uint8_t sar)
{
    IAPCR0 = 0x90;                  //ʹIAPѡѡFLASH
    IAPSAR = sar;
    IAPPAR = 0;
    IAPWAR = 0;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @            : FLASH_Autotmode_Write_Byte
;  *    @˵              : Զģʽֽдʼַ2ֽдFLSAH
;  *    @          : ַ ҳַ ֵַ  дݵĵַ
;  *    @ز          : 
;  ***********************************************/
void FLASH_Autotmode_Write_Byte(uint8_t sar , uint8_t par, uint8_t war, uint16_t data_addr)
{
    IAPCR0 = 0xC4;                  //ʹIAPѡwordѡFLASH
    IAPSAR = sar;                   //ַ
    IAPPAR = par;                   //ҳַ
    IAPWAR = war;                   //ֵַ

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ
    IAPWAR = war;                   //ֵַ

    IAPDRH = data_addr >> 8;
    IAPDRL = data_addr;
    IAPBUFL = 1;                    //ݵ
    while(IAPBUFL);                 //ȴ
    GIE = 0;

    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x03;                  //  д
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT);                 // EE дǷ
}
/************************************************
;  *    @            : FLASH_Automode_Write_PAGE
;  *    @˵              : Զģʽҳдʼַ32ֽдFLSAH
;  *    @          : ַ  ҳַ  дݵʼַ
;  *    @ز          : 
;  ***********************************************/
void FLASH_Automode_Write_PAGE(uint8_t sar , uint8_t par, uint16_t data_addr)
{
    IAPCR0 = 0xC8;                  //ʹIAPѡpageѡEE
    IAPSAR = sar;                   //ַ
    IAPPAR = par;                   //ҳַ
    IAPWAR = 0; 

    //д
    IAPBUFC = 1;                    //
    while(IAPBUFC)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
    IAPDRH = data_addr >> 8;
    IAPDRL = data_addr;
    IAPBUFL = 1;                    //ݵ
    while(IAPBUFL)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x03;                  //д
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴд
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @            : FLASH_Automode_ERASE_word
;  *    @˵              : Զģʽֽڲ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void FLASH_Automode_ERASE_word(uint8_t sar , uint8_t par, uint8_t war)
{
    IAPCR0 = 0xC4;                  //ʹIAPѡwordѡFLASH
    IAPSAR = sar;
    IAPPAR = par;
    IAPWAR = war;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @            : FLASH_Automode_ERASE_PAGE
;  *    @˵              : Զģʽҳ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void FLASH_Automode_ERASE_PAGE(uint8_t sar , uint8_t par)
{
    IAPCR0 = 0xC8;                  //ʹIAPѡҳѡFLASH
    IAPSAR = sar;
    IAPPAR = par;
    IAPWAR = 0;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/************************************************
;  *    @            : FLASH_Automode_ERASE_SECTOR
;  *    @˵              : Զģʽ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void FLASH_Automode_ERASE_SECTOR(uint8_t sar)
{
    IAPCR0 = 0xD0;                  //ʹIAPѡѡFLASH
    IAPSAR = sar;
    IAPPAR = 0;
    IAPWAR = 0;

    IAPDRH = 0;
    IAPDRL = 0;

    IAPBUFC = 1;                    //
    while(IAPBUFC);                 //ȴ

    GIE = 0;
    IAPPR = 0x5A;
    IAPPR = 0xA5;                   //
    IAPCR1 = 0x02;                  //
    Nop();
    Nop();
    GIE = 1;
    while(IAPSTAT)                  //ȴ
    {
        ClrWdt();                   //忴Ź
    }
}
/**************************** end of file *********************************************/