/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------ժҪ---------------------------------
;  *                IIC_Slave(Ӳӻ)
;  *                ͨѶʱٶȽϿʱ֧ʱչ
;  *                ӻַ0xA0
;  *                IIC_SCL:P03
;  *                IIC_SDA:P02
;  *                ADC    :P10
;  *                ܣ
;  *                    IIC ͨѶ
;  *                    1)P10 ɼAD洢ADֵIIC_test_buff2~4λ
;  *                    2)յIIC_test_buff
;  *                    3)鳤Ĭ30ͨ궨IIC_DATA_LEN޸
;  *                עʹPDT1(P00)PCK1(P01)Կ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    u16 i;
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BACK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BACK0();
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : IIC_Init
;  *    @Description         : IICʼ
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/  
void IIC_Init(void)
{
    OEP0 &= DEF_CLR_BIT2;    //SDA
    OEP0 &= DEF_CLR_BIT3;    //SCL

    IOP0 |= DEF_SET_BIT2 | DEF_SET_BIT3;
    

    IICCR0 = 0x50;              //ӻģʽ100KbpsͬԶSTOPʹ0IOѡIICר
    IICSR = 0x00;
    IICDR = 0x00;
    IICAR = 0xA0;               //ӻַ
    IICAAR = 0x00;
    IICAMR = 0x00;
    
    IICIF = 0;
    IICIE = 1;                  //IICжʹ
    IICEN = 1;                  //ʹIIC

    TACKS = 0;
}

/************************************************
;  *    @Function Name       : ADC_Init
;  *    @Description         : ADCʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  *1)ADֵ
;  *    ADֵλΪλ23λΪλλΪ0ʾΪ1Ǹ
;  *    ڸʱλΪ0ADֵΪ23λ
;  *                        СڸʱλΪ1ADֵΪ23λĲ
;  *0x8a5a5a    λΪ1Ǹ23λȡ1ADֵΪ0x75a5a6
;  *    0x765432    λΪ0ADֵ䣬Ϊ0x765432
;  *2)
;  *    : HIRC/24/128 = 2604Hz
;  *    ѹ: VIN = V+ - V-  
;  *    VIN = ADֵ * οѹ / 0x7fffff / ADCŴ / FPGAŴ
;  *3)˽ӵأαƽADʹ
;  ***********************************************/
void ADC_Init(void)
{
    /*1.IOΪģ*/
    OEP1 &= DEF_CLR_BIT0;  //P10
    P1ADCR |= DEF_SET_BIT0 ;//P10ʹģ⹦

    /*2.ADC*/
    ADCR0 |= DEF_SET_BIT5;                                      //ʹVIR
    ADCR0 |= DEF_SET_BIT3 | DEF_SET_BIT2 | DEF_SET_BIT0;        //ʹLDO2.8V
//ѡοѹΪ0.5 VLDOPGAرգADCŴ1
    ADCR1 |= DEF_SET_BIT6 | DEF_SET_BIT1;        
    ADCR2 |= DEF_SET_BIT4 | DEF_SET_BIT0;                       //ʱHIRC/241282604Hz
    ADCR3 = 0;                                                  //رPGAն CHOPƵFdac/
    //ADCR4 &= 0x00;
    //ADCR4 |= DEF_SET_BIT5 | DEF_SET_BIT1 | DEF_SET_BIT0;        //AN2AN3
    ADCR4 = 0x0F;//AN0GND
    
    /*3.ʹADC*/
    ADEN = 1;                                                   //ʹ
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    IIC_Init();
    ADC_Init();
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();

    F_Change_Channel = RESET;

    iic_tx_buffer[0] = 0x11;
    iic_tx_buffer[1] = 0x55;
    iic_tx_buffer[5] = 0xAA;
    while(1)
    {  
        ADCR4 &= 0x00;
        ADCR4 |= (0 << 4) | 0x0F;            //ͨ
        ADCONEN = 1;                         //ת
        ADIF = 0;
        while(ADIF == 0);                   //ȴת
        ADIF = 0;
        if(F_Change_Channel)                //лͨʱ־λ1
        {
            F_Change_Channel = 0;
            ADCONEN = 0;                    //лͨرת
        }

        iic_tx_buffer[2] = ADRH;
        iic_tx_buffer[3] = ADRM;
        iic_tx_buffer[4] = ADRL;  
        //ȡADֵʱIICȡӦóһ棬ʵʱ
        //ǰֵδȡʱһεĻֵ
    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  
/*PFLAGѱGPR1洢ѡλٲRBS*/
    /**********  IIC  **********/
    if(IICIF)
    {
    IIC_CODE:
        if(SADMF)       //ַƥ䣬ӦλTACKSĬΪ0,Ϊ֤ͨŴӻNACK
        {
            iic_tx_idx = IIC_DATA_BUFF_ADDR;     //ʼ
        }
        if(SCMDF)       //
        {
            if((iic_tx_idx-IIC_DATA_BUFF_ADDR) < IIC_DATA_LEN)       
            {
                // IICDR = iic_tx_buffer[iic_tx_idx];

                //ͨѰַʽ߷Ч
                FSR0 = iic_tx_idx;
                IICDR=INDF0;

                iic_tx_idx++;
            }else
            {
                IICDR = 0xFF;    //
            }
        }
        IICIF = 0;
    }
    if(IICIF)
    {
        goto IIC_CODE;
    }
__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}


/**************************** end of file *********************************************/