/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.29
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢
;  *----------------------ժҪ---------------------------------
;  *                   INT0 ⲿжϻ
;  *                5sģʽP13ߵƽ
;  *                P16ⲿжϻѣP13͵ƽ 
******************************************************************************/

#include "user.h"

u16 i;
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BACK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BACK0();
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : ʱ0ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void TIMER0_INT_Init(void)
{
    T0CR |= DEF_SET_BIT1;     //ʱģʽ,CPU,4Ƶ
    T0CNTH = 0x27;
    T0CNTL = 0x10 - 1;
    T0LOADH = 0x27;           //10ms
    T0LOADL = 0x10 - 1;
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @Function Name       : INT_Init
;  *    @Description         : ⲿжϳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void INT0_Init(void)
{
    OEP1 &= DEF_CLR_BIT6;       //P16(INT0) in
    PUP1 |= DEF_SET_BIT6;       //P16(INT0) up

    MCR &= ~(DEF_SET_BIT0 | DEF_SET_BIT1);
    MCR |= DEF_SET_BIT0;        //INT0 ½ش
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    INT0_Init();
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
    while(1)
    {   
        if (FLAG_TIMER0_5000MS)
        {
            FLAG_TIMER0_5000MS = RESET;
            GIE = 0;
            INT0IF = 0;
            INT0IE = 1;
            HFEN = 0;
            LFEN = 0;
            //ǰر AD ʹܻINT0ж
            P13D = 1;
            Nop();
            Nop();
            Stop();
            Nop();
            Nop();
            INT0IE = 0;
            INT0IF = 0;
            GIE = 1;
            //ѺʹرINT0ж ʵӦû
            P13D = 0;
        }
    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;  

    /**********  T0  **********/
    if(T0IE & T0IF)
    {
        T0IF = 0;
        timer0_cnt ++;
        if(timer0_cnt == 500)
        {
            timer0_cnt = 0;
            FLAG_TIMER0_5000MS = 1;
        }
    }

__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}


/**************************** end of file *********************************************/