/******************************************************************************
;  *       @ͺ                 : MS32F7223
;  *       @             : 2023.8.1
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                    HOSC=8MHz
;  *                    Fcpu=4MHz
;  *                    UART
;  *                    RX P03
;  *                    TX P02
;  *                    жϽգ֡ͷ55У׼ʣʷΧ9009-10256
;  *                    յݡ5Aʾ,ɺTX
;  *                    55 12 34 56 78 90 ab cd ef 5a
;  *                    ĬϽ鳤Ϊ30޸ĺ궨UART_RX_BUF_LEN
;  *                    עԿʹPDT1(P00)PCK1(P01)
******************************************************************************/

#include "user.h"

volatile u16 i,j,COUNT;
volatile u8 URTBR_TEMP,KB_NUM;
#define UART_BAUD_MAX             194//10256
#define UART_BAUD_MIN             221//9009
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ4M Լ10us
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     
    {
        Nop();
    }
}
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
//1ҳRA
    BANK1();
    for(FSR1 = 0;FSR1 < 0x7F;FSR1 ++) 
    {
        INDF1 = 0;
    }
    FSR1 = 0x7F;
    INDF1 = 0;
    BANK0();
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ͨIO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void IO_Init(void)
{
    IOP0 = 0;           //IOλ
    OEP0 = 0xFF;        //IOڷ      1:out       0:in
    PUP0 = 0;           //IO    1:enable    0:disable
    PDP0 = 0;           //IO    1:enable    0:disable
    P0ADCR = 0;         //IOѡ    1:ģ  0:ͨIO

    IOP1 = 0;           //IOλ
    OEP1 = 0xFF;        //IOڷ      1:out       0:in
    PUP1 = 0;           //IO    1:enable    0:disable
    PDP1 = 0;           //IO    1:enable    0:disable
    P1ADCR = 0;         //IOѡ    1:ģ  0:ͨIO
}
/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : ʱ0ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void TIMER0_INT_Init(void)
{
    T0CR |= DEF_SET_BIT3;     //ʱģʽ,Hosc,0Ƶ
    T0CNTH = 0xff;
    T0CNTL = 0xff;
    T0LOADH = 0xff; 
    T0LOADL = 0xff;
    T0EN = 0;
    T0IE = 0;
}
/************************************************
;  *    @Function Name       : TIMER2_INT_Init
;  *    @Description         : ʱ2ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void TIMER2_INT_Init(void)
{
    T2CR |= DEF_SET_BIT2|DEF_SET_BIT1|DEF_SET_BIT0;     //ʱģʽ,CPU,128Ƶ
    T2CNT = 249;
    T2LOAD = 249;
    T2EN = 1;
    T2IE = 1;
}
/************************************************
;  *    @Function Name       : UART_Init
;  *    @Description         :   IO
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void UART_Init(void)
{
    OEP0 |= DEF_SET_BIT2;           //TX
    OEP0 &= DEF_CLR_BIT3;           //RX

    PUP0 |= DEF_SET_BIT3;           //RX

    IOP0 |= DEF_SET_BIT2;           //TX
    IOP0 |= DEF_SET_BIT3;           //RX


    URTCR0 = 0x42;              //2Ƶ
    URTCR1 = 0;
    URTCR2 = 0;
    URTBR = URTBR_TEMP;                 //9600

    RXIE = 1;
    UREN = 1;
    URTEN = 1;                  //ʹUART
}
/************************************************
;  *    @Function Name       : UART_Send_Byte
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void UART_Send_Byte(u8 dat)
{
    UREN = 0;
    RXIE = 0;

    URTDR = dat;
    while(0 == TXIF)                //ȴǰݷ
    {
        ClrWdt();                   //忴Ź
    }
    TXIF = 0;

    UREN = 1;
    RXIE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    TIMER2_INT_Init();
    URTBR_TEMP=207;//9600
    UART_Init();
    P03KE=1;
    GIE  = 1;        
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/  
void main(void)
{
    Sys_Init();
    while(1)
    {   
            if(F_RECIEVE_END == 1)
            {
                F_RECIEVE_END = 0;
                for(uart_tx_len = 0;uart_tx_len < uart_rx_len;uart_tx_len++)
                {
                    UART_Send_Byte(uart_rx_buf[uart_tx_len]);
                }
                uart_rx_len = 0;
                Nop();
            }
            else
            {
            	if((P03D)&&(KBIE==0))
            	{
               	    if(F_8MS)
               	    {
               	    	F_8MS=0;
               	        j++;
               	        if(j>25)//200ms
               	        {
               	            j=0;
                            RXIE=0;
                            KB_NUM=0;
               	          	KBIE=1;
               	        }
                    }
                }
            }
    }
}
/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/   
void int_isr(void)__interrupt
{
    __asm
        movra   _abuf
        swapar  _PFLAG
        movra   _statusbuf
        movar   _FSR0     //жֵָ룬豣FSR0,FSR1
        movra   _fsr0buf
        movar   _FSR1
        movra   _fsr1buf
    __endasm;  

    if(RXIE && RXIF)
    {
        RXIF = 0;
        uart_rx_buf[uart_rx_len++] = URTDR;
        if(URTDR == 0x5A)
        {
            F_RECIEVE_END = 1;
        }
    }
    if(T2IE&&T2IF)
    {
       	T2IF=0;
       	F_8MS=1;
    }
    if(KBIE&&KBIF)//жϣT0ʱ
    {
    	KBIF=0;
    	KB_NUM++;
    	if(KB_NUM==2)
    	{
            T0IF=0;
            T0EN=1;
        }
        else if(KB_NUM>=10)
        {
            T0EN=0;
            __asm
            movar T0CNTL
            movra _COUNT
            movar T0CNTH
            movra (_COUNT+1)
            movai 0xff
            xorra _COUNT
            xorra (_COUNT+1)
            __endasm;
            COUNT=COUNT>>5;
            if((COUNT>UART_BAUD_MAX)&&(COUNT<UART_BAUD_MIN))
            {
                URTBR_TEMP=COUNT;
                UART_Init();
            }
            T0CNTH = 0xff;
            T0CNTL = 0xff;
            KB_NUM=0;
            KBIE=0;
            KBIF=0;
        }
    }
    __asm
        movar   _fsr0buf
        movra   _FSR0
        movar   _fsr1buf
        movra   _FSR1
        swapar  _statusbuf
        movra   _PFLAG
        swapr   _abuf
        swapar  _abuf
    __endasm;
}
/**************************** end of file *********************************************/