/******************************************************************************
;  *       @ͺ                 : MC32T7051
;  *       @             : 2025.3.25
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2025 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      ⲿж
;  *                INT0 P05ش P06ת
;  *                INT1 P10½ش P11ת
******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
   	for(FSR0=0; FSR0<0x7F; FSR0++)
   	{
   	   	INDF0 = 0x00;
   	}
    FSR0 = 0x7F;
   	INDF0 =0x00;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable

    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in   
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable

    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    PMOD = 0x00;             //P13D
}

/************************************************
;  *    @Function Name       : INT_Init
;  *    @Description         : ⲿжϳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void INT_Init(void)
{
    OEP0 = 0xDF;             //P05 in
    PDP0 = 0x20;             //P05 down

    OEP1 = 0xFE;             //P10 in
    PUP1 = 0x01;             //P10 up

    MCR &= 0xF4;             //INT0 ش  INT1 ½ش
    INT0IE = 1;
    INT1IE = 1;
}

/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    INT_Init();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
   	   	
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _PFLAG
    movra _statusbuf
    __endasm;

    if ((INT0IF) && (INT0IE)) 
    {
        P06D = !P06D;
        INT0IF = 0;
    }
    if ((INT1IF) && (INT1IE)) 
    {
        P11D = !P11D;
        INT1IF = 0;
    }
    __asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
    __endasm;
}

/**************************** end of file *********************************************/
