/******************************************************************************
;  *       @ͺ                 : MC32T7051
;  *       @             : 2025.3.25
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2025 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      PWM
;  *                PWM0  P11 Duty:20% F=5K
;  *                PWM1  P12 Duty:40% F=10K
;  *                PWM2  P07 Duty:60% F=20K
******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0=0; FSR0<0x7F; FSR0++)
   	{
   	   	INDF0 = 0x00;
   	}
    FSR0 = 0x7F;
   	INDF0 =0x00;

}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable

    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in   
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable

    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    PMOD = 0x00;             //P13D
}

/************************************************
;  *    @Function Name       : TIMER0_PWM_Init
;  *    @Description         : PWM0ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER0_PWM_Init(void)
{
    T0DATA = 20;
    T0CNT = 100-1;
    T0LOAD = 100-1;               //100us
    T0CR = 0xC4;                  //ʱģʽ ʹPWM CPU 16Ƶ  P11PWM
   //  	PWM0CHS0=1;	   	   	   	  //PWM0ͨΪ PWM0O1(P10)  	
}

/************************************************
;  *    @Function Name       : TIMER1_PWM_Init
;  *    @Description         : PWM1ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_PWM_Init(void)
{
    T1DATA = 40;
    T1CNT = 100-1;
    T1LOAD = 100-1;                       //100us
    T1CR = 0xC3;                   	   	  //ʱģʽ ʹPWM CPU 8Ƶ P12PWM
   	//PMOD |=DEF_SET_BIT4;     	   	   	  //PWM1ͨΪ PWM1O1(P13)   	
   	//PMOD |=DEF_SET_BIT5; 	   	   	   	  //PWM1ͨΪ PWM1O1(P14)
   	//PMOD |=DEF_SET_BIT4|DEF_SET_BIT5;    	//PWM1ͨΪ PWM1O1(P15) 	
}
/************************************************
;  *    @Function Name       : TIMER2_PWM_Init
;  *    @Description         : PWM2ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER2_PWM_Init(void)
{
    T2DATA = 60;
    T2CNT = 100-1;
    T2LOAD = 100-1;               //100us
    T2CR = 0xC2;                  //ʱģʽ ʹPWM CPU 4Ƶ P07PWM
   //  	PMOD |=DEF_SET_BIT1;       	   	   	  //PWM2ͨΪ PWM2O1(P04)
   //  	PMOD |=DEF_SET_BIT2;   	   	       	//PWM2ͨΪ PWM2O2(P02)
   //  	PMOD |=DEF_SET_BIT1|DEF_SET_BIT2;  	//PWM2ͨΪ PWM2O3(P03)
   //  	PMOD |=DEF_SET_BIT3;   	   	       	//PWM2ͨΪ PWM2O4(P01)
   //  	PMOD |=DEF_SET_BIT1|DEF_SET_BIT3;  	//PWM2ͨΪ PWM2O5(P05)
   //  	PMOD |=DEF_SET_BIT2|DEF_SET_BIT3;   //PWM2ͨΪ PWM2O6(P06)
   //  	PMOD |=DEF_SET_BIT1|DEF_SET_BIT2|DEF_SET_BIT3; //PWM2ͨΪ PWM2O7(P00)
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_PWM_Init();
    TIMER1_PWM_Init();
    TIMER2_PWM_Init();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {

    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _PFLAG
    movra _statusbuf
    __endasm;

    __asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
    __endasm;
}

/**************************** end of file *********************************************/
