/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30P6250B
;  *   	@             : 2025.08.08
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	   	  CMP    
;  *       	   	   	ѡVDDڲѹ
   	   	   	   	   	ѡEVN5(P15)
   	  ֲṩļ㹫ʽVintr=(1/4+(N+1)/32)*VDD=2.65V //VDD=5V  n=8
   	   	   	   	   	˵ѹ2.65V > ˵ѹ P11
   	   	   	   	֮˵ѹ2.65V < ˵ѹ P11
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : ʼRAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
__asm 
   	movai 0x40 
   	movra FSR
   	movai 47 
   	movra 0x10 
   	decr FSR
   	clrr INDF
   	djzr 0x10 
   	goto $-3;
   	clrr 0x10 
__endasm;
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
   	P1 = 0x00;
   	DDR1 = 0x20;//1:input 0:output  P15
   	PUCON = 0xff; //0:Effective 1:invalid
   	PDCON = 0xff; //0:Effective 1:invalid
   	ODCON = 0x00; //0:  1:©
}
/************************************************
;  *    @Function Name       : CMP_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void CMP_Init(void)
{
   	CMPCR0 |=DEF_SET_BIT6|DEF_SET_BIT5;//ѡVDDڲѹ
   	CMPCR0 |=DEF_SET_BIT4|DEF_SET_BIT2;//ѡEVN5(P15) 	   	  
   	CMPCR1 |=DEF_SET_BIT3;   	   	   	//n=8	   
   	CMPNV=1;   	   	//˿ڶ CMP ȽϽȡ	   
   	CMPEN=1;   	   	//ʹCMP
} 
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
   	GIE = 0;
   	CLR_RAM();
   	IO_Init();
   	CMP_Init();
   	GIE = 1;
}
//=================================================================================
void main(void)
{
   	Sys_Init();
   	while (1)
   	{
   	   	if(CMPOF)  	   	//EVN1<3.5V
   	   	{
   	   	   	P11D=1;
   	   	}
   	   	else 
        {
           	P11D=0;
        }

   	}
}

/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter          	 :
;  *    @Return parameter      	:
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
   	movra _abuf
   	swapar _STATUS
   	movra _statusbuf
__endasm;

   	if ((T0IF) && (T0IE))
   	{
   	   	T0IF = 0;
   	}

   	if ((T1IF) && (T1IE))
   	{
   	   	T1IF = 0;
   	}
   	if ((CMPIE) && (CMPIF))
   	{
   	   	CMPIF = 0;
   	}
__asm 
   	swapar _statusbuf
   	movra _STATUS
   	swapr _abuf
   	swapar _abuf
__endasm;
}


/**************************** end of file *********************************************/