/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30P6250B
;  *   	@             : 2025.08.08
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	   	T1 5s־һ   P10жϻ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : ʼRAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
   	__asm 
   	movai 0x40 
   	movra FSR
   	movai 47 
   	movra 0x10 
   	decr FSR
   	clrr INDF
   	djzr 0x10 
   	goto $-3;
   	clrr 0x10 
   	__endasm;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
   	P1 = 0x00; //1:input 0:output
   	DDR1 = 0x00;   	//1:input 0:output
   	PUCON = 0xff; //0:Effective 1:invalid
   	PDCON = 0xff; //0:Effective 1:invalid
   	ODCON = 0x00; //0:  1:©
}
/************************************************
;  *    @Function Name       : TIMER1_INT_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
   	T1CR = 0x86;   	   	//64Ƶ
   	T1LOAD = 125-1;    	//1ms
   	T1CNT = 125-1;
   	T1IE = 1;
}
/************************************************
;  *    @Function Name       : KBIE_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void KBIE_Init(void)
{
   	DDR1=0x01;//in
   	PUCON=0xfe;//
   	P1KBCR=0x01;//P10ж
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
   	GIE = 0;
   	CLR_RAM();
   	IO_Init();
   	TIMER1_INT_Init();
   	KBIE_Init();
   	GIE = 1;
}
//=================================================================================
void main(void)
{
   	Sys_Init();
   	while (1)
   {
   	   if(FLAG_TIMER1_5000ms)
   	   {
   	   	   	FLAG_TIMER1_5000ms=0;
   	   	   	GIE = 0;
   	   	   	KBIF=0;
   	   	   	KBIE = 1;
   	   	   	Nop();
   	   	   	Nop();
   	   	   	Stop();
   	   	   	Nop();
   	   	   	Nop();
   	   	   	KBIE = 0;
   	   	   	KBIF = 0;
   	   	   	GIE = 1;
   	   }
}
}

/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
   movra _abuf   
   	swapar _STATUS
   	movra _statusbuf
__endasm;

   	if ((T0IF) && (T0IE))
   	{
   	   	T0IF = 0;
   	}

   	if ((T1IF) && (T1IE))
   	{
   	   	T1IF = 0;
   	   	timer1_count1++;
   	   	if(timer1_count1>=5000)
   	   	{
   	   	   	timer1_count1=0;
   	   	   	FLAG_TIMER1_5000ms=1;
   	   	}
   	}
__asm 
   	swapar _statusbuf
   	movra _STATUS
   	swapr _abuf
   	swapar _abuf
__endasm;
}


/**************************** end of file *********************************************/