/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30P6250B
;  *   	@             : 2025.08.08
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	   	TIMER0 	   	P14 1msת
   	   	   	   	   	   	TIMER1 PWM 	
   	   	   	   	   	   	   	   	   	P12  T=80K, D=20% 
   	   	   	   	   	   	   	   	   	P11	 T=80K, D=40% 
   	   	   	   	   	   	   	   	   	P10  T=80K, D=60% 
   	   	   	   	   	   	   	   	   	P15  T=80K, D=80% 
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : C_RAM
;  *    @Description         : ʼRAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void C_RAM(void)
{
   	__asm 
   	movai 0x40 
   	movra FSR
   	movai 47 
   	movra 0x10 
   	decr FSR
   	clrr INDF
   	djzr 0x10 
   	goto $-3;
   	clrr 0x10 
   	__endasm;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
   	P1 = 0x00; //1:input 0:output
   	DDR1 = 0x00;   	//1:input 0:output
   	PUCON = 0xff; //0:Effective 1:invalid
   	PDCON = 0xff; //0:Effective 1:invalid
   	ODCON = 0x00; //0:  1:©
}
/************************************************
;  *    @Function Name       : IO_Config
;  *    @Description         : ͨIO
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
   	T0CR = 0x05; //ʱΪCPUʱ    ʱ64Ƶ  1ms
   	T0CNT = 256 - 125;
   	T0IE = 1;
}
/************************************************
;  *    @Function Name       : IO_Config
;  *    @Description         : ͨIO
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_PWM_Init(void)
{
   	PWM1CR0=0x63;
   	PWM1CR1=0x03;  	   	//ȡ
   	T1LOAD = 100-1;
   	T1CNT = 100-1;
   	T1DATA=20;
   	T1DATB=40;
   	T1DATC=60;
   	T1DATD=80;
   	T1CR = 0xC0;   	   	//Fcpu 1Ƶ
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
   	GIE = 0;
   	C_RAM();
   	IO_Init();
   	TIMER0_INT_Init();
   	TIMER1_PWM_Init();
   	GIE = 1;
}
//=================================================================================
void main(void)
{
   	Sys_Init();
   	while (1)
    {

   	}
}

/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter          	 :
;  *    @Return parameter      	:
;  ***********************************************/
void int_isr(void) __interrupt
{
   	__asm 
   	movra _abuf   
   	swapar _STATUS
   	movra _statusbuf
   	__endasm;

   	if ((T0IF) && (T0IE))
   	{
   	   	T0IF = 0;
   	   	T0CNT = 256 - 125;
   	   	P14D = !P14D;
   	}

   	if ((T1IF) && (T1IE))
   	{
   	   	T1IF = 0;
   	}
   	if ((CMPIE) && (CMPIF))
   	{
   	    CMPIF = 0;
   	}
   	__asm 
   	swapar _statusbuf
   	movra _STATUS
   	swapr _abuf
   	swapar _abuf
   	__endasm;
}


/**************************** end of file *********************************************/