/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30P6250B
;  *   	@             : 2025.08.08
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	   	T0 1S P12תһΣ
******************************************************************************/

#include "user.h"
 
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : ʼRAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
   	__asm 
   	movai 0x40 
   	movra FSR
   	movai 47 
   	movra 0x10 
   	decr FSR
   	clrr INDF
   	djzr 0x10 
   	goto $-3;
   	clrr 0x10 
   	__endasm;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
   	P1 = 0x00; //1:input 0:output
   	DDR1 = 0x00;   	//1:input 0:output
   	PUCON = 0xff; //0:Effective 1:invalid
   	PDCON = 0xff; //0:Effective 1:invalid
   	ODCON = 0x00; //0:  1:©
}
/************************************************
;  *    @Function Name       : TIMER0_RTC_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 :
;  *    @Return parameter    :
;  ***********************************************/
void TIMER0_RTC_Init(void)
{
   	T0CR = 0x07; //256 
   	T0CNT = 256 - 128;//
   	TM0CR=0x80;//Ƶϵͳʱ
   	T0IF = 0;
   	T0IE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
   	GIE = 0;
   	CLR_RAM();
   	IO_Init();
   	TIMER0_RTC_Init();
   	GIE = 1;
}
//=================================================================================
void main(void)
{
   	Sys_Init();
   	while (1)
   {
   	   	GIE = 0;   	   	//رж
   	   	Nop();
   	   	Nop();
   	   	Stop();	   	   	//
   	   	Nop();
   	   	Nop();
   	   	GIE = 1;
   	   	P12D=!P12D;	   	//ж
   	}
}
/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
   	movra _abuf
   	swapar _STATUS
   	movra _statusbuf
__endasm;

   	if ((T0IF) && (T0IE))
   	{
   	   	T0IF = 0;
       	T0CNT = 256 - 128;
   	}

__asm 
   	swapar _statusbuf
   	movra _STATUS
   	swapr _abuf
   	swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/