/******************************************************************************
;  *       @ͺ                 : MC35P7041
;  *       @             : 2021.08.04
;  *       @˾/            : sinomcu.com-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                : 2023 ΢ ˾Ȩ.
;  *----------------------ժҪ---------------------------------  
;  *    P01 1msת 
;  *    2S
;  *    P50 ʹ 
;  *    P00  P44 ADɼ
;  *    עжʹõıȫұʱʹȫֱ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : ʼRAM
;  *    @IN_Parameter           : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0x7f; FSR0++)
    {
        INDF = 0x00;
    }
    FSR0 = 0x7F;
    INDF = 0x00;
}
/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : ioڳʼ
;  *    @IN_Parameter           : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;
    IOP4 = 0x00;
    IOP5 = 0x00;

    OEP0 = 0xfe; //0 in   1 out   P00 in
    OEP4 = 0xef; //0 in   1 out   P44 in
    OEP5 = 0xfe; //0 in   1 out   P50 in
    PUP0 = 0x00; //0 dis  1 en
    PUP4 = 0x00; //0 dis  1 en
    PUP5 = 0x01; //0 dis  1 en       P50up
    AN4EN = 1;
    AN5EN = 1;
    P50WK=1;                 //P50
}
/************************************************
;  *    @Function Name       : ADC_Zero_ADJ
;  *    @Description         : ADCУ׼
;  *    @IN_Parameter           : 
;  *    @Return parameter    : 0 У׼ɹ  1У׼ʧ
;  ***********************************************/
uint8_t ADC_Zero_ADJ(void)
{
    //У׼
    ADCR0=0x9A;                  //GND
    ADCR1=0x8F;                  //64Ƶ  15CLK
    ADCR2=0x03;               //ڲ2V
    ZEROTR=0x40;              //У׼ 

    ADEOC=0;
    ADSTR = 1; // ʼת
    while (!ADEOC); // EOCı־λ   ȴת
    if (((ADRH& 0x0F) == 0) && (ADRL  == 0)) //ǷΪ0
    {
        ZEROTR|=0x10;             //
        ZEROTR|=0x0F;
        while(1)
        {
            if(ZEROTR & 0x0f)
            {
                ADEOC=0;
                ADSTR = 1; // ʼת
                while (!ADEOC); // EOCı־λ   ȴת
                if (((ADRH& 0x0F) == 0) && (ADRL  == 0)) //ǷΪ0
                {
                    ZEROTR&=0x3F;             //رУ׼
                    ADEN=0;                  //رADC
                    return PASS; 
                }
                ZEROTR--;
                }else 
                {
                    ZEROTR&=0x3F;             //رУ׼
                    ADEN=0;                  //رADC
                    return FAIL; 
                }
            }
    }else
    {
        while(1)
        {
            if ((ZEROTR & 0x0f) != 0x0f) 
            {
                ZEROTR++;
                ADEOC=0;
                ADSTR = 1; // ʼת
                while (!ADEOC); // EOCı־λ   ȴת
                if (((ADRH& 0x0F) == 0) && (ADRL  == 0)) //ǷΪ0
                {
                    ZEROTR&=0x3F;             //رУ׼
                    ADEN=0;                  //رADC
                    return PASS; 
                }
            }
            else
            {
                ZEROTR&=0x3F;             //رУ׼
                ADEN=0;                  //رADC
                 return FAIL; 
            }                    
        }
    }
}
/************************************************
;  *    @Function Name       : TIMER1_INT_Init
;  *    @Description         : 
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = 0x34; //8Ƶ  Ƶ32M
    T1LDR = 256 - 250; //  1ms
    T1EN = 1;
    T1IE = 1;
}
/************************************************
;  *    @Function Name       : ADC_Init
;  *    @Description         : ADCʼ
;  *    @IN_Parameter           : 
;  *    @Return parameter    :
;  ***********************************************/
void ADC_Init(void)
{
    ADCR1 = 0x8f;
    ADCR2 = 0x03; //ڲ2V
    ADCR0 = 0x90;
}
/************************************************
;  *    @Function Name       : InitSys
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter           : 
;  *    @Return parameter    :
;  ***********************************************/
void InitSys(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    //while(ADC_Zero_ADJ());      //ADCУ׼  
    //ʱҪرУ׼,У׼,ʵICӰ
    TIMER1_INT_Init();
    ADC_Init();
    GIE = 1;
}
/************************************************
;  *    @Function Name       : ADC_Get_Value
;  *    @Description         : ADCת
;  *    @IN_Parameter               : CHX  ADCͨ
;  *    @Return parameter    : ͨADCֵ
;  ***********************************************/
uint16_t ADC_Get_Value(u8 CHX)
{
    ADC_num_temp1 = 0;
    ADCR0 = (ADCR0 & 0xf0) | CHX; // ADC ʹ  ADתͨ  ͨ  CHX

    if (changl_num != CHX) //ͨл  ȥ
    {
        changl_num = CHX;
        ADEOC=0;
        ADSTR = 1; // ʼת
        while (!ADEOC); // EOCı־λ   ȴת
    }
    ADEOC=0;
    ADSTR = 1; // ʼת
    while (!ADEOC);// EOCı־λ   ȴת
    ADC_num_temp1 = ADRH & 0x0f;
    ADC_num_temp1 = ADC_num_temp1 << 8 | ADRL;
    return ADC_num_temp1; // ADCת
}
/************************************************
;  *    @Function Name       : ADC_Get_Value_Average
;  *    @Description         : ADCת
;  *    @IN_Parameter        : CHX  ADCͨ
;  *    @Return parameter    : ͨADCֵ
;  ***********************************************/
uint16_t ADC_Get_Value_Average(u8 CHX)
{
    ADC_num_temp = 0;
    channel = 0;
    tmpbuff = 0;
    ADCMAX = 0;
    ADCMIN = 0xffff;

    ADCR0 = (ADCR0 & 0xf0) | CHX; // ADC ʹ  ADתͨ  ͨ  CHX
    for (channel = 0; channel < 20; channel++)
    {
        ADEOC=0;
        ADSTR = 1; // ʼת
        while (!ADEOC); //ȴת
        ADC_num_temp = ADRH & 0x0f;
        ADC_num_temp = ADC_num_temp << 8;
        ADC_num_temp |= ADRL;
        if (channel < 2)
            continue; //ǰβ
        if (ADC_num_temp > ADCMAX)
            ADCMAX = ADC_num_temp; //
        if (ADC_num_temp < ADCMIN)
            ADCMIN = ADC_num_temp; //С
        tmpbuff += ADC_num_temp;
    }
    tmpbuff -= ADCMAX;                   //ȥһ
    tmpbuff -= ADCMIN;                   //ȥһС
    ADC_num_temp = (tmpbuff >> 4); //16ȡƽֵ
    return ADC_num_temp;
}
void main(void)
{
    InitSys();
    while (1)
    {
        ADC_value = ADC_Get_Value_Average(4);         //P44
        ADC_value = ADC_Get_Value_Average(5);                           //P00

        if(FLAG_TIMER0_2000ms)                              //
        {
            FLAG_TIMER0_2000ms=0;
            ADEN=0;                  //ر
            P01D=0;
                     
            OSCM&=0xe7;
            OSCM|=0x08;    
            Nop();
            Nop();
            ADEN=1;                  //            
        }        
    }
}

void int_isr(void) __interrupt
{
    __asm 
    push
    __endasm;
    if (T1IF && T1IE)
    {
        T1IF = 0;
        P01D=!P01D;    
        timer1_count1++;
        if(timer1_count1>=2000)
        {
            timer1_count1=0;
            FLAG_TIMER0_2000ms=1;
        }
    }
    __asm 
    pop
    __endasm;
}


/**************************** end of file *********************************************/




