/******************************************************************************
;  *       @ͺ                 : MC35P7050
;  *       @             : 2021.08.04
;  *       @˾/            : sinomcu.com-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                : 2023 ΢ ˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *    P44P53 PWM              
;  *    7050ʹ7040
;  *    PWMҪӳ书
;  *    עжʹõıȫұʱʹȫֱ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : 
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
__asm 
    movai 0x3F 
    movra FSR0
    clrr FSR1
    clrr INDF
    DJZR FSR0 
    goto $ -2
    clrr INDF
__endasm;
}
/************************************************
;  *    @Function Name       : IO_Config
;  *    @Description         : ioڳʼ
;  *    @IN_Parameter           : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00; //ioλ
    OEP0 = 0xff; //ioڷ 1:out  0:in
    PUP0 = 0x00; //io   1:enable  0:disable

    IOP4 = 0x00; //ioλ
    OEP4 = 0xff; //ioڷ 1:out  0:in
    PUP4 = 0x00; //io   1:enable  0:disable

    IOP5 = 0x00; //ioλ
    OEP5 = 0xff; //ioڷ 1:out  0:in
    PUP5 = 0x00; //io   1:enable  0:disable

    P4CON = 0x00;
}
/************************************************
;  *    @Function Name       : TIMER0_PWM_Init
;  *    @Description         : ʱʼ
;  *    @IN_Parameter           : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER0_PWM_Init(void)
{
    TMRCR = 0;   //T1CLK=FCPU/2      T0CLK=FCPU/2    رT0
    T0CR = 0xF1; //T0 1Ƶ  T0CLKڲʱ  Զ  PWM  256ʱ
    //T0CNT = 256 - 125;
    T0LDR = 0x7f; 
}
/************************************************
;  *    @Function Name       : TIMER1_PWM_Init
;  *    @Description         : 
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_PWM_Init(void)
{
    T1CR = 0xf1;
    T1LDR = 0x80; //T1    1Ƶ  T1CLKڲʱ  PWM  256
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter           : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_PWM_Init();
    TIMER1_PWM_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    while (1)
    {

    }
}

void int_isr(void) __interrupt
{
    __asm 
    push
    __endasm;

    __asm 
    pop
    __endasm;
}
