;******************************************************************************
;  *   	@MCU   	   	     : MC32F7062
;  *   	@Create Date         : 2021.11.29
;  *   	@Corporation         : SinoMCU
;  *   	@֧QQȺ           :  814641858      
;  *    @΢ٷ           :http://www.sinomcu.com/
;  *   	@Copyright           : 2021 SINOMCU Corporation,All Rights Reserved.
;  *----------------------Abstract Description--------------------------------- 
;wr4wr5wr6wr7/wr0wr1wr2wr3 = wr8wr9wr10wr11 ....... wr12wr13wr14wr15
;------------------------------------------------------------------------------
;wr4wr5wr6wr7         (λwr4wr5λwr6wr7)
;wr0wr1wr2wr3         (λwr0wr1λwr2wr3)
;wr8wr9wr10wr11       (λwr8wr9λwr10wr11)
;wr12wr13wr14wr15     (λwr12wr13λwr14wr15)
;wr16        λ
;------------------------------------------------------------------------------
;=================================================
#include <mc32f7062.inc>
#include <Div_32x32.h>
;=================================================
   	   	extern 	   	Div32_Init
abuf                equ                 00H
statusbuf           equ                 01H


;------------------------------------------------------------------------------
   	    ORG             000H
       	goto   	       	Reset
;-----------------------------------------------------------------------------
        ORG             008H
Interrup_In:
        movra  	       	abuf
        swapar 	       	PFLAG
        movra  	       	statusbuf
Interrupt_Out:
        swapar 	       	statusbuf
        movra  	       	PFLAG
        swapr  	       	abuf
        swapar 	       	abuf
        retie
;------------------------------------------------------------------------------
Reset:
        bclr   	       	GIE
        call            CLR_RAM
        call            IO_Init
;------------------------------------------------------------------------------

MainLoop:
    clrwdt
;-------------------------
    movai   0x87
    movra   wr4
    movai   0x65
    movra   wr5
    movai   0x43
    movra   wr6
    movai   0x21
    movra   wr7
;-------------------------
    movai   0x12
    movra   wr0
    movai   0x34
    movra   wr1
    movai   0x56
    movra   wr2
    movai   0x78
    movra   wr3
   	call   	Div32_Init
    nop
    nop
    goto            MainLoop

IO_Init:
        clrr    IOP0
        clrr    IOP1
        clrr    IOP2
        MOVAI   0xff
        MOVRA   OEP0
        MOVRA   OEP1
        MOVRA   OEP2
        CLRR    PUP0
        CLRR    PUP1
        CLRR    PUP2
        CLRR    PDP0
        CLRR    PDP1
        CLRR    PDP2
        RETURN

CLR_RAM:
        CLRR    FSR0
        MOVAI   0XFF
        rsubar  FSR0
        JBCLR   C
        GOTO    $+4
        CLRR    INDF0
        INCR    FSR0
        GOTO    $-6
        MOVAI   0XFF
        MOVRA   FSR0
        CLRR    INDF0
        RETURN

        END